/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagDataPack;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;

public class RegistryMaterials<T>
implements IRegistryWritable<T> {
    private final ResourceKey<? extends IRegistry<T>> b;
    private final ObjectList<Holder.c<T>> c = new ObjectArrayList(256);
    private final Reference2IntMap<T> d = (Reference2IntMap)SystemUtils.a(new Reference2IntOpenHashMap(), (? super T var0) -> var0.defaultReturnValue(-1));
    private final Map<MinecraftKey, Holder.c<T>> e = new HashMap<MinecraftKey, Holder.c<T>>();
    private final Map<ResourceKey<T>, Holder.c<T>> f = new HashMap<ResourceKey<T>, Holder.c<T>>();
    private final Map<T, Holder.c<T>> g = new IdentityHashMap<T, Holder.c<T>>();
    private final Map<ResourceKey<T>, RegistrationInfo> h = new IdentityHashMap<ResourceKey<T>, RegistrationInfo>();
    private Lifecycle i;
    private final Map<TagKey<T>, HolderSet.Named<T>> j = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>();
    a<T> k = a.a();
    private boolean l;
    @Nullable
    private Map<T, Holder.c<T>> m;

    @Override
    public Stream<HolderSet.Named<T>> e() {
        return this.l();
    }

    public RegistryMaterials(ResourceKey<? extends IRegistry<T>> var0, Lifecycle var1) {
        this(var0, var1, false);
    }

    public RegistryMaterials(ResourceKey<? extends IRegistry<T>> var02, Lifecycle var1, boolean var2) {
        this.b = var02;
        this.i = var1;
        if (var2) {
            this.m = new IdentityHashMap<T, Holder.c<T>>();
        }
    }

    @Override
    public ResourceKey<? extends IRegistry<T>> g() {
        return this.b;
    }

    public String toString() {
        return "Registry[" + String.valueOf(this.b) + " (" + String.valueOf(this.i) + ")]";
    }

    private void b() {
        if (this.l) {
            throw new IllegalStateException("Registry is already frozen");
        }
    }

    private void h(ResourceKey<T> var0) {
        if (this.l) {
            throw new IllegalStateException("Registry is already frozen (trying to add key " + String.valueOf(var0) + ")");
        }
    }

    @Override
    public Holder.c<T> a(ResourceKey<T> var02, T var1, RegistrationInfo var2) {
        Holder.c var3;
        this.h(var02);
        Objects.requireNonNull(var02);
        Objects.requireNonNull(var1);
        if (this.e.containsKey(var02.a())) {
            throw SystemUtils.b(new IllegalStateException("Adding duplicate key '" + String.valueOf(var02) + "' to registry"));
        }
        if (this.g.containsKey(var1)) {
            throw SystemUtils.b(new IllegalStateException("Adding duplicate value '" + String.valueOf(var1) + "' to registry"));
        }
        if (this.m != null) {
            var3 = this.m.remove(var1);
            if (var3 == null) {
                throw new AssertionError((Object)("Missing intrusive holder for " + String.valueOf(var02) + ":" + String.valueOf(var1)));
            }
            var3.b(var02);
        } else {
            var3 = this.f.computeIfAbsent(var02, var0 -> Holder.c.a(this, var0));
        }
        this.f.put(var02, var3);
        this.e.put(var02.a(), var3);
        this.g.put(var1, var3);
        int var4 = this.c.size();
        this.c.add((Object)var3);
        this.d.put(var1, var4);
        this.h.put(var02, var2);
        this.i = this.i.add(var2.b());
        return var3;
    }

    @Override
    @Nullable
    public MinecraftKey b(T var0) {
        Holder.c<T> var1 = this.g.get(var0);
        return var1 != null ? var1.h().a() : null;
    }

    @Override
    public Optional<ResourceKey<T>> d(T var0) {
        return Optional.ofNullable(this.g.get(var0)).map(Holder.c::h);
    }

    @Override
    public int a(@Nullable T var0) {
        return this.d.getInt(var0);
    }

    @Override
    @Nullable
    public T c(@Nullable ResourceKey<T> var0) {
        return RegistryMaterials.a(this.f.get(var0));
    }

    @Override
    @Nullable
    public T a(int var0) {
        if (var0 < 0 || var0 >= this.c.size()) {
            return null;
        }
        return ((Holder.c)this.c.get(var0)).a();
    }

    @Override
    public Optional<Holder.c<T>> c(int var0) {
        if (var0 < 0 || var0 >= this.c.size()) {
            return Optional.empty();
        }
        return Optional.ofNullable((Holder.c)this.c.get(var0));
    }

    @Override
    public Optional<Holder.c<T>> c(MinecraftKey var0) {
        return Optional.ofNullable(this.e.get(var0));
    }

    @Override
    public Optional<Holder.c<T>> a(ResourceKey<T> var0) {
        return Optional.ofNullable(this.f.get(var0));
    }

    @Override
    public Optional<Holder.c<T>> a() {
        return this.c.isEmpty() ? Optional.empty() : Optional.of((Holder.c)this.c.getFirst());
    }

    @Override
    public Holder<T> e(T var0) {
        Holder.c<T> var1 = this.g.get(var0);
        return var1 != null ? var1 : Holder.a(var0);
    }

    Holder.c<T> i(ResourceKey<T> var02) {
        return this.f.computeIfAbsent(var02, var0 -> {
            if (this.m != null) {
                throw new IllegalStateException("This registry can't create new holders without value");
            }
            this.h((ResourceKey<T>)var0);
            return Holder.c.a(this, var0);
        });
    }

    @Override
    public int d() {
        return this.f.size();
    }

    @Override
    public Optional<RegistrationInfo> d(ResourceKey<T> var0) {
        return Optional.ofNullable(this.h.get(var0));
    }

    @Override
    public Lifecycle h() {
        return this.i;
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.transform((Iterator)this.c.iterator(), Holder::a);
    }

    @Override
    @Nullable
    public T a(@Nullable MinecraftKey var0) {
        Holder.c<T> var1 = this.e.get(var0);
        return RegistryMaterials.a(var1);
    }

    @Nullable
    private static <T> T a(@Nullable Holder.c<T> var0) {
        return var0 != null ? (T)var0.a() : null;
    }

    @Override
    public Set<MinecraftKey> i() {
        return Collections.unmodifiableSet(this.e.keySet());
    }

    @Override
    public Set<ResourceKey<T>> j() {
        return Collections.unmodifiableSet(this.f.keySet());
    }

    @Override
    public Set<Map.Entry<ResourceKey<T>, T>> k() {
        return Collections.unmodifiableSet(SystemUtils.a(this.f, Holder::a).entrySet());
    }

    @Override
    public Stream<Holder.c<T>> c() {
        return this.c.stream();
    }

    @Override
    public Stream<HolderSet.Named<T>> l() {
        return this.k.c();
    }

    HolderSet.Named<T> d(TagKey<T> var0) {
        return this.j.computeIfAbsent(var0, this::e);
    }

    @Override
    private HolderSet.Named<T> e(TagKey<T> var0) {
        return new HolderSet.Named<T>(this, var0);
    }

    @Override
    public boolean m() {
        return this.f.isEmpty();
    }

    @Override
    public Optional<Holder.c<T>> a(RandomSource var0) {
        return SystemUtils.b(this.c, var0);
    }

    @Override
    public boolean d(MinecraftKey var0) {
        return this.e.containsKey(var0);
    }

    @Override
    public boolean e(ResourceKey<T> var0) {
        return this.f.containsKey(var0);
    }

    @Override
    public IRegistry<T> n() {
        if (this.l) {
            return this;
        }
        this.l = true;
        this.g.forEach((? super K var0, ? super V var1) -> var1.b(var0));
        List<MinecraftKey> var02 = this.f.entrySet().stream().filter(var0 -> !((Holder.c)var0.getValue()).b()).map(var0 -> ((ResourceKey)var0.getKey()).a()).sorted().toList();
        if (!var02.isEmpty()) {
            throw new IllegalStateException("Unbound values in registry " + String.valueOf(this.g()) + ": " + String.valueOf(var02));
        }
        if (this.m != null) {
            if (!this.m.isEmpty()) {
                throw new IllegalStateException("Some intrusive holders were not registered: " + String.valueOf(this.m.values()));
            }
            this.m = null;
        }
        if (this.k.b()) {
            throw new IllegalStateException("Tags already present before freezing");
        }
        List<MinecraftKey> var12 = this.j.entrySet().stream().filter(var0 -> !((HolderSet.Named)var0.getValue()).c()).map(var0 -> ((TagKey)var0.getKey()).b()).sorted().toList();
        if (!var12.isEmpty()) {
            throw new IllegalStateException("Unbound tags in registry " + String.valueOf(this.g()) + ": " + String.valueOf(var12));
        }
        this.k = a.a(this.j);
        this.u();
        return this;
    }

    @Override
    public Holder.c<T> f(T var02) {
        if (this.m == null) {
            throw new IllegalStateException("This registry can't create intrusive holders");
        }
        this.b();
        return this.m.computeIfAbsent(var02, var0 -> Holder.c.a(this, var0));
    }

    @Override
    public Optional<HolderSet.Named<T>> a(TagKey<T> var0) {
        return this.k.a(var0);
    }

    private Holder.c<T> a(TagKey<T> var0, Holder<T> var1) {
        if (!var1.a(this)) {
            throw new IllegalStateException("Can't create named set " + String.valueOf(var0) + " containing value " + String.valueOf(var1) + " from outside registry " + String.valueOf(this));
        }
        if (var1 instanceof Holder.c) {
            Holder.c var2 = (Holder.c)var1;
            return var2;
        }
        throw new IllegalStateException("Found direct holder " + String.valueOf(var1) + " value in tag " + String.valueOf(var0));
    }

    @Override
    public void a(TagKey<T> var0, List<Holder<T>> var1) {
        this.b();
        this.d(var0).b(var1);
    }

    void u() {
        IdentityHashMap<Holder.c, List> var0 = new IdentityHashMap<Holder.c, List>();
        this.f.values().forEach(var1 -> var0.put((Holder.c)var1, new ArrayList()));
        this.k.a((? super TagKey<T> var1, ? super HolderSet.Named<T> var2) -> {
            for (Holder var4 : var2) {
                Holder.c var5 = this.a((TagKey<T>)var1, var4);
                ((List)var0.get(var5)).add(var1);
            }
        });
        var0.forEach(Holder.c::a);
    }

    public void o() {
        this.b();
        this.j.values().forEach(var0 -> var0.b(List.of()));
    }

    @Override
    public HolderGetter<T> p() {
        this.b();
        return new HolderGetter<T>(){

            @Override
            public Optional<Holder.c<T>> a(ResourceKey<T> var0) {
                return Optional.of(this.b(var0));
            }

            @Override
            public Holder.c<T> b(ResourceKey<T> var0) {
                return RegistryMaterials.this.i(var0);
            }

            @Override
            public Optional<HolderSet.Named<T>> a(TagKey<T> var0) {
                return Optional.of(this.b(var0));
            }

            @Override
            public HolderSet.Named<T> b(TagKey<T> var0) {
                return RegistryMaterials.this.d(var0);
            }
        };
    }

    @Override
    public IRegistry.a<T> a(TagDataPack.c<T> var0) {
        if (!this.l) {
            throw new IllegalStateException("Invalid method used for tag loading");
        }
        ImmutableMap.Builder var1 = ImmutableMap.builder();
        final HashMap var22 = new HashMap();
        var0.b().forEach((? super K var2, ? super V var3) -> {
            HolderSet.Named<T> var4 = this.j.get(var2);
            if (var4 == null) {
                var4 = this.e((TagKey<T>)var2);
            }
            var1.put(var2, var4);
            var22.put(var2, List.copyOf(var3));
        });
        final ImmutableMap var32 = var1.build();
        final HolderLookup.b.a var4 = new HolderLookup.b.a<T>(){

            @Override
            public HolderLookup.b<T> a() {
                return RegistryMaterials.this;
            }

            @Override
            public Optional<HolderSet.Named<T>> a(TagKey<T> var0) {
                return Optional.ofNullable((HolderSet.Named)var32.get(var0));
            }

            @Override
            public Stream<HolderSet.Named<T>> e() {
                return var32.values().stream();
            }
        };
        return new IRegistry.a<T>(){

            @Override
            public ResourceKey<? extends IRegistry<? extends T>> a() {
                return RegistryMaterials.this.g();
            }

            @Override
            public int b() {
                return var22.size();
            }

            @Override
            public HolderLookup.b<T> c() {
                return var4;
            }

            @Override
            public void d() {
                var32.forEach((var1, var2) -> {
                    List var3 = var22.getOrDefault(var1, List.of());
                    var2.b(var3);
                });
                RegistryMaterials.this.k = a.a(var32);
                RegistryMaterials.this.u();
            }
        };
    }

    static interface a<T> {
        public static <T> a<T> a() {
            return new a<T>(){

                @Override
                public boolean b() {
                    return false;
                }

                @Override
                public Optional<HolderSet.Named<T>> a(TagKey<T> var0) {
                    throw new IllegalStateException("Tags not bound, trying to access " + String.valueOf(var0));
                }

                @Override
                public void a(BiConsumer<? super TagKey<T>, ? super HolderSet.Named<T>> var0) {
                    throw new IllegalStateException("Tags not bound");
                }

                @Override
                public Stream<HolderSet.Named<T>> c() {
                    throw new IllegalStateException("Tags not bound");
                }
            };
        }

        public static <T> a<T> a(final Map<TagKey<T>, HolderSet.Named<T>> var0) {
            return new a<T>(){

                @Override
                public boolean b() {
                    return true;
                }

                @Override
                public Optional<HolderSet.Named<T>> a(TagKey<T> var02) {
                    return Optional.ofNullable((HolderSet.Named)var0.get(var02));
                }

                @Override
                public void a(BiConsumer<? super TagKey<T>, ? super HolderSet.Named<T>> var02) {
                    var0.forEach(var02);
                }

                @Override
                public Stream<HolderSet.Named<T>> c() {
                    return var0.values().stream();
                }
            };
        }

        public boolean b();

        public Optional<HolderSet.Named<T>> a(TagKey<T> var1);

        public void a(BiConsumer<? super TagKey<T>, ? super HolderSet.Named<T>> var1);

        public Stream<HolderSet.Named<T>> c();
    }
}

