/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ClientboundServerLinksPacket;
import net.minecraft.network.protocol.common.ServerboundClientInformationPacket;
import net.minecraft.network.protocol.common.ServerboundResourcePackPacket;
import net.minecraft.network.protocol.common.custom.BrandPayload;
import net.minecraft.network.protocol.configuration.ClientboundUpdateEnabledFeaturesPacket;
import net.minecraft.network.protocol.configuration.ServerConfigurationPacketListener;
import net.minecraft.network.protocol.configuration.ServerboundAcceptCodeOfConductPacket;
import net.minecraft.network.protocol.configuration.ServerboundFinishConfigurationPacket;
import net.minecraft.network.protocol.configuration.ServerboundSelectKnownPacks;
import net.minecraft.network.protocol.game.GameProtocols;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ServerLinks;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.config.JoinWorldTask;
import net.minecraft.server.network.config.PrepareSpawnTask;
import net.minecraft.server.network.config.ServerCodeOfConductConfigurationTask;
import net.minecraft.server.network.config.ServerResourcePackConfigurationTask;
import net.minecraft.server.network.config.SynchronizeRegistriesTask;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.flag.FeatureFlags;
import org.bukkit.craftbukkit.v1_21_R6.CraftServerLinks;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerLinksSendEvent;
import org.slf4j.Logger;

public class ServerConfigurationPacketListenerImpl
extends ServerCommonPacketListenerImpl
implements ServerConfigurationPacketListener,
TickablePacketListener {
    private static final Logger f = LogUtils.getLogger();
    private static final IChatBaseComponent g = IChatBaseComponent.c("multiplayer.disconnect.invalid_player_data");
    private static final IChatBaseComponent h = IChatBaseComponent.c("multiplayer.disconnect.configuration_error");
    private final GameProfile i;
    private final Queue<ConfigurationTask> j = new ConcurrentLinkedQueue<ConfigurationTask>();
    @Nullable
    private ConfigurationTask k;
    private ClientInformation l;
    @Nullable
    private SynchronizeRegistriesTask m;
    @Nullable
    private PrepareSpawnTask n;

    public ServerConfigurationPacketListenerImpl(MinecraftServer minecraftserver, NetworkManager networkmanager, CommonListenerCookie commonlistenercookie, EntityPlayer player) {
        super(minecraftserver, networkmanager, commonlistenercookie, player);
        this.i = commonlistenercookie.a();
        this.l = commonlistenercookie.c();
    }

    @Override
    protected GameProfile i() {
        return this.i;
    }

    @Override
    public void a(DisconnectionDetails disconnectiondetails) {
        f.info("{} ({}) lost connection: {}", new Object[]{this.i.name(), this.i.id(), disconnectiondetails.a().getString()});
        if (this.n != null) {
            this.n.d();
            this.n = null;
        }
        super.a(disconnectiondetails);
    }

    @Override
    public boolean c() {
        return this.e.i();
    }

    public void l() {
        this.b(new ClientboundCustomPayloadPacket(new BrandPayload(this.d.getServerModName())));
        ServerLinks serverlinks = this.d.bx();
        CraftServerLinks wrapper = new CraftServerLinks(serverlinks);
        PlayerLinksSendEvent event = new PlayerLinksSendEvent((Player)this.player.getBukkitEntity(), (org.bukkit.ServerLinks)wrapper);
        this.player.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        serverlinks = wrapper.getServerLinks();
        if (!serverlinks.a()) {
            this.b(new ClientboundServerLinksPacket(serverlinks.b()));
        }
        LayeredRegistryAccess<RegistryLayer> layeredregistryaccess = this.d.bh();
        List<KnownPack> list = this.d.bk().b().flatMap(iresourcepack -> iresourcepack.a().d().stream()).toList();
        this.b(new ClientboundUpdateEnabledFeaturesPacket(FeatureFlags.e.b(this.d.bf().J())));
        this.m = new SynchronizeRegistriesTask(list, layeredregistryaccess);
        this.j.add(this.m);
        this.n();
        this.m();
    }

    public void m() {
        this.n = new PrepareSpawnTask(this.d, this.player);
        this.j.add(this.n);
        this.j.add(new JoinWorldTask());
        this.o();
    }

    private void n() {
        Map<String, String> map = this.d.ad();
        if (!map.isEmpty()) {
            this.j.add(new ServerCodeOfConductConfigurationTask(() -> {
                String s2 = (String)map.get(this.l.b().toLowerCase(Locale.ROOT));
                if (s2 == null) {
                    s2 = (String)map.get("en_us");
                }
                if (s2 == null) {
                    s2 = (String)map.values().iterator().next();
                }
                return s2;
            }));
        }
        this.d.ae().ifPresent(minecraftserver_serverresourcepackinfo -> this.j.add(new ServerResourcePackConfigurationTask((MinecraftServer.ServerResourcePackInfo)minecraftserver_serverresourcepackinfo)));
    }

    @Override
    public void a(ServerboundClientInformationPacket serverboundclientinformationpacket) {
        this.l = serverboundclientinformationpacket.b();
    }

    @Override
    public void a(ServerboundResourcePackPacket serverboundresourcepackpacket) {
        super.a(serverboundresourcepackpacket);
        if (serverboundresourcepackpacket.e().a()) {
            this.a(ServerResourcePackConfigurationTask.a);
        }
    }

    @Override
    public void a(ServerboundSelectKnownPacks serverboundselectknownpacks) {
        PlayerConnectionUtils.a(serverboundselectknownpacks, this, this.d.bz());
        if (this.m == null) {
            throw new IllegalStateException("Unexpected response from client: received pack selection, but no negotiation ongoing");
        }
        this.m.a(serverboundselectknownpacks.b(), this::b);
        this.a(SynchronizeRegistriesTask.a);
    }

    @Override
    public void a(ServerboundAcceptCodeOfConductPacket serverboundacceptcodeofconductpacket) {
        this.a(ServerCodeOfConductConfigurationTask.a);
    }

    @Override
    public void a(ServerboundFinishConfigurationPacket serverboundfinishconfigurationpacket) {
        PlayerConnectionUtils.a(serverboundfinishconfigurationpacket, this, this.d.bz());
        this.a(JoinWorldTask.a);
        this.e.a(GameProtocols.c.a(RegistryFriendlyByteBuf.a(this.d.bg())));
        try {
            PlayerList playerlist = this.d.am();
            if (playerlist.b(this.i.id()) != null) {
                this.a(PlayerList.f);
                return;
            }
            IChatBaseComponent ichatbasecomponent = null;
            if (ichatbasecomponent != null) {
                this.a(ichatbasecomponent);
                return;
            }
            EntityPlayer entityplayer = this.player;
            entityplayer.a(this.l);
            Objects.requireNonNull(this.n).a(this.e, this.a(this.l));
        }
        catch (Exception exception) {
            f.error("Couldn't place player in world", (Throwable)exception);
            this.a(g);
        }
    }

    @Override
    public void d() {
        this.e();
        ConfigurationTask configurationtask = this.k;
        if (configurationtask != null) {
            try {
                if (configurationtask.a()) {
                    this.a(configurationtask.b());
                }
            }
            catch (Exception exception) {
                f.error("Failed to tick configuration task {}", (Object)configurationtask.b(), (Object)exception);
                this.a(h);
            }
        }
        if (this.n != null) {
            this.n.c();
        }
    }

    private void o() {
        ConfigurationTask configurationtask;
        if (this.k != null) {
            throw new IllegalStateException("Task " + this.k.b().a() + " has not finished yet");
        }
        if (this.c() && (configurationtask = this.j.poll()) != null) {
            this.k = configurationtask;
            try {
                configurationtask.a(this::b);
            }
            catch (Exception exception) {
                f.error("Failed to start configuration task {}", (Object)configurationtask.b(), (Object)exception);
                this.a(h);
            }
        }
    }

    private void a(ConfigurationTask.a configurationtask_a) {
        ConfigurationTask.a configurationtask_a1;
        ConfigurationTask.a a2 = configurationtask_a1 = this.k != null ? this.k.b() : null;
        if (!configurationtask_a.equals(configurationtask_a1)) {
            String s2 = String.valueOf(configurationtask_a1);
            throw new IllegalStateException("Unexpected request for task finish, current task: " + s2 + ", requested: " + String.valueOf(configurationtask_a));
        }
        this.k = null;
        this.o();
    }
}

