/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.List;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterBedBlock
extends DataFix {
    public DataConverterBedBlock(Schema var0, boolean var1) {
        super(var0, var1);
    }

    public TypeRewriteRule makeRule() {
        Type var0 = this.getOutputSchema().getType(DataConverterTypes.d);
        Type var1 = var0.findFieldType("Level");
        Type var2 = var1.findFieldType("TileEntities");
        if (!(var2 instanceof List.ListType)) {
            throw new IllegalStateException("Tile entity type is not a list type.");
        }
        List.ListType var3 = (List.ListType)var2;
        return this.a(var1, var3);
    }

    private <TE> TypeRewriteRule a(Type<?> var0, List.ListType<TE> var1) {
        Type var2 = var1.getElement();
        OpticFinder var3 = DSL.fieldFinder((String)"Level", var0);
        OpticFinder var4 = DSL.fieldFinder((String)"TileEntities", var1);
        int var5 = 416;
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhere("InjectBedBlockEntityType", (Type)this.getInputSchema().findChoiceType(DataConverterTypes.u), (Type)this.getOutputSchema().findChoiceType(DataConverterTypes.u), var02 -> var0 -> var0), (TypeRewriteRule)this.fixTypeEverywhereTyped("BedBlockEntityInjecter", this.getOutputSchema().getType(DataConverterTypes.d), var32 -> {
            Typed var42 = var32.getTyped(var3);
            Dynamic var52 = (Dynamic)var42.get(DSL.remainderFinder());
            int var6 = var52.get("xPos").asInt(0);
            int var7 = var52.get("zPos").asInt(0);
            ArrayList var8 = Lists.newArrayList((Iterable)((Iterable)var42.getOrCreate(var4)));
            List var9 = var52.get("Sections").asList(Function.identity());
            for (Dynamic var11 : var9) {
                int var12 = var11.get("Y").asInt(0);
                Streams.mapWithIndex((IntStream)var11.get("Blocks").asIntStream(), (var4, var5) -> {
                    if (416 == (var4 & 0xFF) << 4) {
                        int var7 = (int)var5;
                        int var8 = var7 & 0xF;
                        int var9 = var7 >> 8 & 0xF;
                        int var10 = var7 >> 4 & 0xF;
                        HashMap var11 = Maps.newHashMap();
                        var11.put(var11.createString("id"), var11.createString("minecraft:bed"));
                        var11.put(var11.createString("x"), var11.createInt(var8 + (var6 << 4)));
                        var11.put(var11.createString("y"), var11.createInt(var9 + (var12 << 4)));
                        var11.put(var11.createString("z"), var11.createInt(var10 + (var7 << 4)));
                        var11.put(var11.createString("color"), var11.createShort((short)14));
                        return var11;
                    }
                    return null;
                }).forEachOrdered(var3 -> {
                    if (var3 != null) {
                        var8.add(((Pair)var2.read(var11.createMap(var3)).result().orElseThrow(() -> new IllegalStateException("Could not parse newly created bed block entity."))).getFirst());
                    }
                });
            }
            if (!var8.isEmpty()) {
                return var32.set(var3, var42.set(var4, (Object)var8));
            }
            return var32;
        }));
    }
}

