/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.gossip;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.DoublePredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.UUIDUtil;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.ai.gossip.ReputationType;
import net.minecraft.world.entity.npc.EntityVillager;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.entity.Villager;
import org.bukkit.event.entity.VillagerReputationChangeEvent;

public class Reputation {
    public static final Codec<Reputation> a = net.minecraft.world.entity.ai.gossip.Reputation$b.a.listOf().xmap(Reputation::new, reputation -> reputation.e().toList());
    public static final int b = 2;
    private final Map<UUID, a> c = new HashMap<UUID, a>();
    public EntityVillager villager;

    public Reputation(EntityVillager villager) {
        this.villager = villager;
    }

    public Reputation() {
    }

    private Reputation(List<b> list) {
        list.forEach(reputation_b -> this.a((UUID)reputation_b.b).a.put((Object)reputation_b.c, reputation_b.d));
    }

    @VisibleForDebug
    public Map<UUID, Object2IntMap<ReputationType>> a() {
        HashMap map = Maps.newHashMap();
        this.c.keySet().forEach(uuid -> {
            a reputation_a = this.c.get(uuid);
            map.put(uuid, reputation_a.a);
        });
        return map;
    }

    public void b() {
        Iterator<Map.Entry<UUID, a>> iterator = this.c.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, a> reputation_a = iterator.next();
            reputation_a.getValue().decay(this.villager, reputation_a.getKey());
            if (!reputation_a.getValue().b()) continue;
            iterator.remove();
        }
    }

    private Stream<b> e() {
        return this.c.entrySet().stream().flatMap(entry -> ((a)entry.getValue()).a((UUID)entry.getKey()));
    }

    private Collection<b> a(RandomSource randomsource, int i2) {
        List<b> list = this.e().toList();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        int[] aint = new int[list.size()];
        int j2 = 0;
        for (int k2 = 0; k2 < list.size(); ++k2) {
            b reputation_b = list.get(k2);
            aint[k2] = (j2 += Math.abs(reputation_b.a())) - 1;
        }
        Set set = Sets.newIdentityHashSet();
        for (int l2 = 0; l2 < i2; ++l2) {
            int i1 = randomsource.a(j2);
            int j1 = Arrays.binarySearch(aint, i1);
            set.add(list.get(j1 < 0 ? -j1 - 1 : j1));
        }
        return set;
    }

    private a a(UUID uuid) {
        return this.c.computeIfAbsent(uuid, uuid1 -> new a());
    }

    public void a(Reputation reputation, RandomSource randomsource, int i2) {
        Collection<b> collection = reputation.a(randomsource, i2);
        collection.forEach(reputation_b -> {
            int j2 = reputation_b.d - reputation_b.c.m;
            if (j2 >= 2) {
                this.set(reputation_b.b, reputation_b.c, Reputation.a(this.getReputation(reputation_b.b, Predicate.isEqual(reputation_b.c), false), j2), Villager.ReputationEvent.GOSSIP);
            }
        });
    }

    public int a(UUID uuid, Predicate<ReputationType> predicate) {
        return this.getReputation(uuid, predicate, true);
    }

    public int getReputation(UUID uuid, Predicate<ReputationType> predicate, boolean weighted) {
        a reputation_a = this.c.get(uuid);
        return reputation_a != null ? (weighted ? reputation_a.a(predicate) : reputation_a.unweightedValue(predicate)) : 0;
    }

    public long a(ReputationType reputationtype, DoublePredicate doublepredicate) {
        return this.c.values().stream().filter(reputation_a -> doublepredicate.test(reputation_a.a.getOrDefault((Object)reputationtype, 0) * reputationtype.j)).count();
    }

    public void a(UUID uuid, ReputationType reputationtype, int i2) {
        this.add(uuid, reputationtype, i2, Villager.ReputationEvent.UNSPECIFIED);
    }

    public void add(UUID uuid, ReputationType reputationtype, int i2, Villager.ReputationEvent changeReason) {
        a reputation_a = this.a(uuid);
        int oldValue = reputation_a.a.getInt((Object)reputationtype);
        reputation_a.a.mergeInt((Object)reputationtype, i2, (j2, k2) -> this.a(reputationtype, j2, k2));
        int newValue = reputation_a.a.getInt((Object)reputationtype);
        newValue = Math.max(0, Math.min(newValue, reputationtype.k));
        reputation_a.a.replace((Object)reputationtype, oldValue);
        VillagerReputationChangeEvent event = CraftEventFactory.callVillagerReputationChangeEvent((Villager)this.villager.getBukkitEntity(), uuid, changeReason, CraftVillager.CraftReputationType.minecraftToBukkit(reputationtype), oldValue, newValue, reputationtype.k);
        if (!event.isCancelled()) {
            reputation_a.a.replace((Object)reputationtype, event.getNewValue());
            reputation_a.a(reputationtype);
        }
        if (reputation_a.b()) {
            this.c.remove(uuid);
        }
    }

    public void set(UUID uuid, ReputationType reputationType, int i2, Villager.ReputationEvent changeReason) {
        int addAmount = i2 - this.getReputation(uuid, Predicate.isEqual(reputationType), false);
        if (addAmount == 0) {
            return;
        }
        this.add(uuid, reputationType, addAmount, changeReason);
    }

    public void remove(UUID uuid, ReputationType reputationtype, int i2, Villager.ReputationEvent changeReason) {
        this.add(uuid, reputationtype, -i2, changeReason);
    }

    public void remove(UUID uuid, ReputationType reputationtype, Villager.ReputationEvent changeReason) {
        a reputation_a = this.c.get(uuid);
        if (reputation_a != null) {
            this.set(uuid, reputationtype, 0, changeReason);
            if (reputation_a.b()) {
                this.c.remove(uuid);
            }
        }
    }

    public void remove(ReputationType reputationtype, Villager.ReputationEvent changeReason) {
        HashSet uuids = Sets.newHashSet(this.c.keySet());
        for (UUID uuid : uuids) {
            this.remove(uuid, reputationtype, changeReason);
        }
    }

    public void c() {
        this.c.clear();
    }

    public void a(Reputation reputation) {
        reputation.c.forEach((uuid, reputation_a) -> this.a((UUID)uuid).a.putAll(reputation_a.a));
    }

    private static int a(int i2, int j2) {
        return Math.max(i2, j2);
    }

    private int a(ReputationType reputationtype, int i2, int j2) {
        int k2 = i2 + j2;
        return k2 > reputationtype.k ? Math.max(reputationtype.k, i2) : k2;
    }

    public Reputation d() {
        Reputation reputation = new Reputation(this.villager);
        reputation.a(this);
        return reputation;
    }

    private static class a {
        final Object2IntMap<ReputationType> a = new Object2IntOpenHashMap();

        a() {
        }

        public int a(Predicate<ReputationType> predicate) {
            return this.a.object2IntEntrySet().stream().filter(entry -> predicate.test((ReputationType)entry.getKey())).mapToInt(entry -> entry.getIntValue() * ((ReputationType)entry.getKey()).j).sum();
        }

        public int unweightedValue(Predicate<ReputationType> predicate) {
            return this.a.object2IntEntrySet().stream().filter(entry -> predicate.test((ReputationType)entry.getKey())).mapToInt(entry -> entry.getIntValue()).sum();
        }

        public Stream<b> a(UUID uuid) {
            return this.a.object2IntEntrySet().stream().map(entry -> new b(uuid, (ReputationType)entry.getKey(), entry.getIntValue()));
        }

        public void decay(EntityVillager villager, UUID uuid) {
            ObjectIterator objectiterator = this.a.object2IntEntrySet().iterator();
            while (objectiterator.hasNext()) {
                Object2IntMap.Entry object2intmap_entry = (Object2IntMap.Entry)objectiterator.next();
                int i2 = object2intmap_entry.getIntValue() - ((ReputationType)object2intmap_entry.getKey()).l;
                VillagerReputationChangeEvent event = CraftEventFactory.callVillagerReputationChangeEvent((Villager)villager.getBukkitEntity(), uuid, Villager.ReputationEvent.DECAY, CraftVillager.CraftReputationType.minecraftToBukkit((ReputationType)object2intmap_entry.getKey()), object2intmap_entry.getIntValue(), i2, ((ReputationType)object2intmap_entry.getKey()).k);
                if (event.isCancelled()) continue;
                i2 = event.getNewValue();
                if (i2 < 2) {
                    objectiterator.remove();
                    continue;
                }
                object2intmap_entry.setValue(i2);
            }
        }

        public boolean b() {
            return this.a.isEmpty();
        }

        public void a(ReputationType reputationtype) {
            int i2 = this.a.getInt((Object)reputationtype);
            if (i2 > reputationtype.k) {
                this.a.put((Object)reputationtype, reputationtype.k);
            }
            if (i2 < 2) {
                this.b(reputationtype);
            }
        }

        public void b(ReputationType reputationtype) {
            this.a.removeInt((Object)reputationtype);
        }
    }

    private record b(UUID b, ReputationType c, int d) {
        public static final Codec<b> a = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.a.fieldOf("Target").forGetter(b::b), (App)ReputationType.n.fieldOf("Type").forGetter(b::c), (App)ExtraCodecs.p.fieldOf("Value").forGetter(b::d)).apply((Applicative)instance, b::new));

        public int a() {
            return this.d * this.c.j;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "target;type;value", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "target;type;value", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "target;type;value", "b", "c", "d"}, this, o2);
        }
    }
}

