/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFleeSun;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalNearestVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWaterJumpAbstract;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.animal.EntityFishSchool;
import net.minecraft.world.entity.animal.EntityPolarBear;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.wolf.EntityWolf;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSweetBerryBush;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityFox
extends EntityAnimal {
    private static final DataWatcherObject<Integer> cx = DataWatcher.a(EntityFox.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Byte> cy = DataWatcher.a(EntityFox.class, DataWatcherRegistry.a);
    private static final int cz = 1;
    public static final int ct = 4;
    public static final int cu = 8;
    public static final int cv = 16;
    private static final int cA = 32;
    private static final int cB = 64;
    private static final int cC = 128;
    public static final DataWatcherObject<Optional<EntityReference<EntityLiving>>> cD = DataWatcher.a(EntityFox.class, DataWatcherRegistry.r);
    public static final DataWatcherObject<Optional<EntityReference<EntityLiving>>> cE = DataWatcher.a(EntityFox.class, DataWatcherRegistry.r);
    static final Predicate<EntityItem> cF = entityitem -> !entityitem.n() && entityitem.bX();
    private static final Predicate<Entity> cG = entity -> {
        if (!(entity instanceof EntityLiving)) {
            return false;
        }
        EntityLiving entityliving = (EntityLiving)entity;
        return entityliving.eI() != null && entityliving.eJ() < entityliving.at + 600;
    };
    static final Predicate<Entity> cH = entity -> entity instanceof EntityChicken || entity instanceof EntityRabbit;
    private static final Predicate<Entity> cI = entity -> !entity.cs() && IEntitySelector.e.test((Entity)entity);
    private static final int cJ = 600;
    private static final EntitySize cK = EntityTypes.ad.n().a(0.5f).b(0.2975f);
    private static final Codec<List<EntityReference<EntityLiving>>> cL = EntityReference.a().listOf();
    private static final boolean cM = false;
    private static final boolean cN = false;
    private static final boolean cO = false;
    private PathfinderGoal cP;
    private PathfinderGoal cS;
    private PathfinderGoal cT;
    private float cU;
    private float cV;
    float cW;
    float cX;
    private int cY;

    public EntityFox(EntityTypes<? extends EntityFox> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
        this.cm = new k();
        this.cn = new m();
        this.a(PathType.p, 0.0f);
        this.a(PathType.q, 0.0f);
        this.a_(true);
        this.S().a(32.0f);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cD, Optional.empty());
        datawatcher_a.a(cE, Optional.empty());
        datawatcher_a.a(cx, Type.c.a());
        datawatcher_a.a(cy, (byte)0);
    }

    @Override
    protected void H() {
        this.cP = new PathfinderGoalNearestAttackableTarget<EntityAnimal>(this, EntityAnimal.class, 10, false, false, (entityliving, worldserver) -> entityliving instanceof EntityChicken || entityliving instanceof EntityRabbit);
        this.cS = new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, false, false, EntityTurtle.ct);
        this.cT = new PathfinderGoalNearestAttackableTarget<EntityFish>(this, EntityFish.class, 20, false, false, (entityliving, worldserver) -> entityliving instanceof EntityFishSchool);
        this.cq.a(0, new g());
        this.cq.a(0, new ClimbOnTopOfPowderSnowGoal(this, this.an()));
        this.cq.a(1, new b());
        this.cq.a(2, new n(2.2));
        this.cq.a(3, new e(this, 1.0));
        this.cq.a(4, new PathfinderGoalAvoidTarget<EntityHuman>(this, EntityHuman.class, 16.0f, 1.6, 1.4, entityliving -> cI.test((Entity)entityliving) && !this.j((EntityLiving)entityliving) && !this.gW()));
        this.cq.a(4, new PathfinderGoalAvoidTarget<EntityWolf>(this, EntityWolf.class, 8.0f, 1.6, 1.4, entityliving -> !((EntityWolf)entityliving).m() && !this.gW()));
        this.cq.a(4, new PathfinderGoalAvoidTarget<EntityPolarBear>(this, EntityPolarBear.class, 8.0f, 1.6, 1.4, entityliving -> !this.gW()));
        this.cq.a(5, new u());
        this.cq.a(6, new o());
        this.cq.a(6, new s(1.25));
        this.cq.a(7, new l((double)1.2f, true));
        this.cq.a(7, new t());
        this.cq.a(8, new h(this, 1.25));
        this.cq.a(9, new q(32, 200));
        this.cq.a(10, new f((double)1.2f, 12, 1));
        this.cq.a(10, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.cq.a(11, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.cq.a(11, new p());
        this.cq.a(12, new j(this, EntityHuman.class, 24.0f));
        this.cq.a(13, new r());
        this.cr.a(3, new a(EntityLiving.class, false, false, (entityliving, worldserver) -> cG.test(entityliving) && !this.j(entityliving)));
    }

    @Override
    public void e_() {
        if (!this.an().D_() && this.bX() && this.dt()) {
            EntityLiving entityliving;
            ++this.cY;
            ItemStack itemstack = this.a(EnumItemSlot.a);
            if (this.j(itemstack)) {
                if (this.cY > 600) {
                    ItemStack itemstack1 = itemstack.a(this.an(), (EntityLiving)this);
                    if (!itemstack1.f()) {
                        this.a(EnumItemSlot.a, itemstack1);
                    }
                    this.cY = 0;
                } else if (this.cY > 560 && this.as.i() < 0.1f) {
                    this.gO();
                    this.an().a((Entity)this, (byte)45);
                }
            }
            if ((entityliving = this.e()) == null || !entityliving.bX()) {
                this.z(false);
                this.A(false);
            }
        }
        if (this.gg() || this.fv()) {
            this.bL = false;
            this.bM = 0.0f;
            this.bO = 0.0f;
        }
        super.e_();
        if (this.gW() && this.as.i() < 0.05f) {
            this.a(SoundEffects.kx, 1.0f, 1.0f);
        }
    }

    @Override
    protected boolean fv() {
        return this.eV();
    }

    private boolean j(ItemStack itemstack) {
        return itemstack.c(DataComponents.v) && this.e() == null && this.aS() && !this.gg();
    }

    @Override
    protected void a(RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        if (randomsource.i() < 0.2f) {
            float f2 = randomsource.i();
            ItemStack itemstack = f2 < 0.05f ? new ItemStack(Items.qb) : (f2 < 0.2f ? new ItemStack(Items.sD) : (f2 < 0.4f ? (randomsource.h() ? new ItemStack(Items.wM) : new ItemStack(Items.wN)) : (f2 < 0.6f ? new ItemStack(Items.rc) : (f2 < 0.8f ? new ItemStack(Items.sp) : new ItemStack(Items.qZ)))));
            this.a(EnumItemSlot.a, itemstack);
        }
    }

    @Override
    public void b(byte b0) {
        if (b0 == 45) {
            ItemStack itemstack = this.a(EnumItemSlot.a);
            if (!itemstack.f()) {
                for (int i2 = 0; i2 < 8; ++i2) {
                    Vec3D vec3d = new Vec3D(((double)this.as.i() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).a(-this.dZ() * ((float)Math.PI / 180)).b(-this.dX() * ((float)Math.PI / 180));
                    this.an().a(new ParticleParamItem(Particles.V, itemstack), this.dK() + this.cf().g / 2.0, this.dM(), this.dQ() + this.cf().i / 2.0, vec3d.g, vec3d.h + 0.05, vec3d.i);
                }
            }
        } else {
            super.b(b0);
        }
    }

    public static AttributeProvider.Builder m() {
        return EntityAnimal.gN().a(GenericAttributes.w, 0.3f).a(GenericAttributes.t, 10.0).a(GenericAttributes.c, 2.0).a(GenericAttributes.y, 5.0).a(GenericAttributes.n, 32.0);
    }

    @Nullable
    public EntityFox b(WorldServer worldserver, EntityAgeable entityageable) {
        EntityFox entityfox = EntityTypes.ad.a(worldserver, EntitySpawnReason.e);
        if (entityfox != null) {
            entityfox.a(this.as.h() ? this.n() : ((EntityFox)entityageable).n());
        }
        return entityfox;
    }

    public static boolean c(EntityTypes<EntityFox> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        return generatoraccess.a_(blockposition.e()).a(TagsBlock.cs) && EntityFox.a(generatoraccess, blockposition);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        Holder<BiomeBase> holder = worldaccess.v(this.dF());
        Type entityfox_type = Type.a(holder);
        boolean flag = false;
        if (groupdataentity instanceof i) {
            i entityfox_i = (i)groupdataentity;
            entityfox_type = entityfox_i.a;
            if (entityfox_i.a() >= 2) {
                flag = true;
            }
        } else {
            groupdataentity = new i(entityfox_type);
        }
        this.a(entityfox_type);
        if (flag) {
            this.c_(-24000);
        }
        if (worldaccess instanceof WorldServer) {
            this.gM();
        }
        this.a(worldaccess.I_(), difficultydamagescaler);
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    private void gM() {
        if (this.n() == Type.a) {
            this.cr.a(4, this.cP);
            this.cr.a(4, this.cS);
            this.cr.a(6, this.cT);
        } else {
            this.cr.a(4, this.cT);
            this.cr.a(6, this.cP);
            this.cr.a(6, this.cS);
        }
    }

    @Override
    protected void gO() {
        this.a(SoundEffects.kB, 1.0f, 1.0f);
    }

    @Override
    public EntitySize b(EntityPose entitypose) {
        return this.g_() ? cK : super.b(entitypose);
    }

    public Type n() {
        return Type.a(this.az.a(cx));
    }

    public void a(Type entityfox_type) {
        this.az.a(cx, entityfox_type.a());
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.az ? EntityFox.c(datacomponenttype, this.n()) : super.a(datacomponenttype);
    }

    @Override
    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.az);
        super.a(datacomponentgetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.az) {
            this.a(EntityFox.c(DataComponents.az, t0));
            return true;
        }
        return super.b(datacomponenttype, t0);
    }

    Stream<EntityReference<EntityLiving>> gU() {
        return Stream.concat(this.az.a(cD).stream(), this.az.a(cE).stream());
    }

    void i(EntityLiving entityliving) {
        this.a(EntityReference.a(entityliving));
    }

    private void a(EntityReference<EntityLiving> entityreference) {
        if (this.az.a(cD).isPresent()) {
            this.az.a(cE, Optional.of(entityreference));
        } else {
            this.az.a(cD, Optional.of(entityreference));
        }
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("Trusted", cL, this.gU().toList());
        valueoutput.a("Sleeping", this.gg());
        valueoutput.a("Type", Type.d, this.n());
        valueoutput.a("Sitting", this.s());
        valueoutput.a("Crouching", this.cu());
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.gV();
        valueinput.a("Trusted", cL).orElse(List.of()).forEach(this::a);
        this.D(valueinput.a("Sleeping", false));
        this.a(valueinput.a("Type", Type.d).orElse(Type.c));
        this.x(valueinput.a("Sitting", false));
        this.z(valueinput.a("Crouching", false));
        if (this.an() instanceof WorldServer) {
            this.gM();
        }
    }

    private void gV() {
        this.az.a(cD, Optional.empty());
        this.az.a(cE, Optional.empty());
    }

    public boolean s() {
        return this.s(1);
    }

    public void x(boolean flag) {
        this.d(1, flag);
    }

    public boolean gI() {
        return this.s(64);
    }

    void B(boolean flag) {
        this.d(64, flag);
    }

    boolean gW() {
        return this.s(128);
    }

    void C(boolean flag) {
        this.d(128, flag);
    }

    @Override
    public boolean gg() {
        return this.s(32);
    }

    public void D(boolean flag) {
        this.d(32, flag);
    }

    private void d(int i2, boolean flag) {
        if (flag) {
            this.az.a(cy, (byte)(this.az.a(cy) | i2));
        } else {
            this.az.a(cy, (byte)(this.az.a(cy) & ~i2));
        }
    }

    private boolean s(int i2) {
        return (this.az.a(cy) & i2) != 0;
    }

    @Override
    protected boolean f(EnumItemSlot enumitemslot) {
        return enumitemslot == EnumItemSlot.a && this.gc();
    }

    @Override
    public boolean g(ItemStack itemstack) {
        ItemStack itemstack1 = this.a(EnumItemSlot.a);
        return itemstack1.f() || this.cY > 0 && itemstack.c(DataComponents.v) && !itemstack1.c(DataComponents.v);
    }

    private void k(ItemStack itemstack) {
        if (!itemstack.f() && !this.an().D_()) {
            EntityItem entityitem = new EntityItem(this.an(), this.dK() + this.cf().g, this.dM() + 1.0, this.dQ() + this.cf().i, itemstack);
            entityitem.b(40);
            entityitem.b((Entity)this);
            this.a(SoundEffects.kG, 1.0f, 1.0f);
            this.an().b(entityitem);
        }
    }

    private void l(ItemStack itemstack) {
        EntityItem entityitem = new EntityItem(this.an(), this.dK(), this.dM(), this.dQ(), itemstack);
        this.an().b(entityitem);
    }

    @Override
    protected void a(WorldServer worldserver, EntityItem entityitem) {
        ItemStack itemstack = entityitem.e();
        if (!CraftEventFactory.callEntityPickupItemEvent(this, entityitem, itemstack.M() - 1, !this.g(itemstack)).isCancelled()) {
            itemstack = entityitem.e();
            int i2 = itemstack.M();
            if (i2 > 1) {
                this.l(itemstack.a(i2 - 1));
            }
            this.k(this.a(EnumItemSlot.a));
            this.a(entityitem);
            this.a(EnumItemSlot.a, itemstack.a(1));
            this.g(EnumItemSlot.a);
            this.a((Entity)entityitem, itemstack.M());
            entityitem.discard(EntityRemoveEvent.Cause.PICKUP);
            this.cY = 0;
        }
    }

    @Override
    public void g() {
        super.g();
        if (this.dt()) {
            boolean flag = this.bu();
            if (flag || this.e() != null || this.an().ai()) {
                this.gX();
            }
            if (flag || this.gg()) {
                this.x(false);
            }
            if (this.gI() && this.an().z.i() < 0.2f) {
                BlockPosition blockposition = this.dF();
                IBlockData iblockdata = this.an().a_(blockposition);
                this.an().c(2001, blockposition, Block.j(iblockdata));
            }
        }
        this.cV = this.cU;
        this.cU = this.gL() ? (this.cU += (1.0f - this.cU) * 0.4f) : (this.cU += (0.0f - this.cU) * 0.4f);
        this.cX = this.cW;
        if (this.cu()) {
            this.cW += 0.2f;
            if (this.cW > 3.0f) {
                this.cW = 3.0f;
            }
        } else {
            this.cW = 0.0f;
        }
    }

    @Override
    public boolean i(ItemStack itemstack) {
        return itemstack.a(TagsItem.aD);
    }

    @Override
    protected void a(EntityHuman entityhuman, EntityInsentient entityinsentient) {
        ((EntityFox)entityinsentient).i(entityhuman);
    }

    public boolean gJ() {
        return this.s(16);
    }

    public void y(boolean flag) {
        this.d(16, flag);
    }

    public boolean gK() {
        return this.cW == 3.0f;
    }

    public void z(boolean flag) {
        this.d(4, flag);
    }

    @Override
    public boolean cu() {
        return this.s(4);
    }

    public void A(boolean flag) {
        this.d(8, flag);
    }

    public boolean gL() {
        return this.s(8);
    }

    public float J(float f2) {
        return MathHelper.h(f2, this.cV, this.cU) * 0.11f * (float)Math.PI;
    }

    public float K(float f2) {
        return MathHelper.h(f2, this.cX, this.cW);
    }

    @Override
    public void g(@Nullable EntityLiving entityliving) {
        if (this.gW() && entityliving == null) {
            this.C(false);
        }
        super.g(entityliving);
    }

    void gX() {
        this.D(false);
    }

    void gY() {
        this.A(false);
        this.z(false);
        this.x(false);
        this.D(false);
        this.C(false);
        this.B(false);
    }

    boolean gZ() {
        return !this.gg() && !this.s() && !this.gI();
    }

    @Override
    public void X() {
        SoundEffect soundeffect = this.p();
        if (soundeffect == SoundEffects.kD) {
            this.a(soundeffect, 2.0f, this.fu());
        } else {
            super.X();
        }
    }

    @Override
    @Nullable
    protected SoundEffect p() {
        List<Entity> list;
        if (this.gg()) {
            return SoundEffects.kE;
        }
        if (!this.an().aa() && this.as.i() < 0.1f && (list = this.an().a(EntityHuman.class, this.de().c(16.0, 16.0, 16.0), IEntitySelector.f)).isEmpty()) {
            return SoundEffects.kD;
        }
        return SoundEffects.ky;
    }

    @Override
    @Nullable
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.kC;
    }

    @Override
    @Nullable
    protected SoundEffect f_() {
        return SoundEffects.kA;
    }

    boolean j(EntityLiving entityliving) {
        return this.gU().anyMatch(entityreference -> entityreference.b(entityliving));
    }

    @Override
    protected void b(WorldServer worldserver, DamageSource damagesource) {
        ItemStack itemstack = this.a(EnumItemSlot.a);
        if (!itemstack.f()) {
            this.a(worldserver, itemstack);
            this.a(EnumItemSlot.a, ItemStack.l);
        }
        super.b(worldserver, damagesource);
    }

    public static boolean a(EntityFox entityfox, EntityLiving entityliving) {
        double d0 = entityliving.dQ() - entityfox.dQ();
        double d1 = entityliving.dK() - entityfox.dK();
        double d2 = d0 / d1;
        int i2 = 6;
        for (int j2 = 0; j2 < 6; ++j2) {
            double d3 = d2 == 0.0 ? 0.0 : d0 * (double)((float)j2 / 6.0f);
            double d4 = d2 == 0.0 ? d1 * (double)((float)j2 / 6.0f) : d3 / d2;
            for (int k2 = 1; k2 < 4; ++k2) {
                if (entityfox.an().a_(BlockPosition.a(entityfox.dK() + d4, entityfox.dM() + (double)k2, entityfox.dQ() + d3)).v()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Vec3D F() {
        return new Vec3D(0.0, 0.55f * this.df(), this.dA() * 0.4f);
    }

    public class k
    extends ControllerLook {
        public k() {
            super(EntityFox.this);
        }

        @Override
        public void a() {
            if (!EntityFox.this.gg()) {
                super.a();
            }
        }

        @Override
        protected boolean c() {
            return !EntityFox.this.gJ() && !EntityFox.this.cu() && !EntityFox.this.gL() && !EntityFox.this.gI();
        }
    }

    private class m
    extends ControllerMove {
        public m() {
            super(EntityFox.this);
        }

        @Override
        public void a() {
            if (EntityFox.this.gZ()) {
                super.a();
            }
        }
    }

    public static enum Type implements INamable
    {
        a(0, "red"),
        b(1, "snow");

        public static final Type c;
        public static final INamable.a<Type> d;
        private static final IntFunction<Type> f;
        public static final StreamCodec<ByteBuf, Type> e;
        private final int g;
        private final String h;

        private Type(int i2, String s2) {
            this.g = i2;
            this.h = s2;
        }

        @Override
        public String c() {
            return this.h;
        }

        public int a() {
            return this.g;
        }

        public static Type a(int i2) {
            return f.apply(i2);
        }

        public static Type a(Holder<BiomeBase> holder) {
            return holder.a(BiomeTags.at) ? b : a;
        }

        static {
            c = a;
            d = INamable.a(Type::values);
            f = ByIdMap.a(Type::a, Type.values(), ByIdMap.a.a);
            e = ByteBufCodecs.a(f, Type::a);
        }
    }

    private class g
    extends PathfinderGoalFloat {
        public g() {
            super(EntityFox.this);
        }

        @Override
        public void d() {
            super.d();
            EntityFox.this.gY();
        }

        @Override
        public boolean b() {
            return EntityFox.this.bu() && EntityFox.this.b(TagsFluid.a) > 0.25 || EntityFox.this.bJ();
        }
    }

    private class b
    extends PathfinderGoal {
        int a;

        public b() {
            this.a(EnumSet.of(PathfinderGoal.Type.b, PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            return EntityFox.this.gI();
        }

        @Override
        public boolean c() {
            return this.b() && this.a > 0;
        }

        @Override
        public void d() {
            this.a = this.a(40);
        }

        @Override
        public void e() {
            EntityFox.this.B(false);
        }

        @Override
        public void a() {
            --this.a;
        }
    }

    private class n
    extends PathfinderGoalPanic {
        public n(double d0) {
            super(EntityFox.this, d0);
        }

        @Override
        public boolean h() {
            return !EntityFox.this.gW() && super.h();
        }
    }

    private class e
    extends PathfinderGoalBreed {
        public e(EntityFox entityFox, double d0) {
            super(entityFox, d0);
        }

        @Override
        public void d() {
            ((EntityFox)this.a).gY();
            ((EntityFox)this.c).gY();
            super.d();
        }

        @Override
        protected void g() {
            WorldServer worldserver = this.b;
            EntityFox entityfox = (EntityFox)this.a.a(worldserver, (EntityAgeable)this.c);
            if (entityfox != null) {
                EntityPlayer entityplayer = this.a.gR();
                EntityPlayer entityplayer1 = this.c.gR();
                EntityPlayer entityplayer2 = entityplayer;
                if (entityplayer != null) {
                    entityfox.i(entityplayer);
                } else {
                    entityplayer2 = entityplayer1;
                }
                if (entityplayer1 != null && entityplayer != entityplayer1) {
                    entityfox.i(entityplayer1);
                }
                entityfox.c_(-24000);
                entityfox.b(this.a.dK(), this.a.dM(), this.a.dQ(), 0.0f, 0.0f);
                int experience = this.a.ek().a(7) + 1;
                EntityBreedEvent entityBreedEvent = CraftEventFactory.callEntityBreedEvent(entityfox, this.a, this.c, entityplayer, this.a.breedItem, experience);
                if (entityBreedEvent.isCancelled()) {
                    return;
                }
                experience = entityBreedEvent.getExperience();
                if (entityplayer2 != null) {
                    entityplayer2.a(StatisticList.Q);
                    CriterionTriggers.p.a(entityplayer2, this.a, this.c, entityfox);
                }
                this.a.c_(6000);
                this.c.c_(6000);
                this.a.gT();
                this.c.gT();
                worldserver.addFreshEntityWithPassengers(entityfox, CreatureSpawnEvent.SpawnReason.BREEDING);
                this.b.a((Entity)this.a, (byte)18);
                if (worldserver.S().c(GameRules.g) && experience > 0) {
                    this.b.b(new EntityExperienceOrb(this.b, this.a.dK(), this.a.dM(), this.a.dQ(), experience));
                }
            }
        }
    }

    private class u
    extends PathfinderGoal {
        public u() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            if (EntityFox.this.gg()) {
                return false;
            }
            EntityLiving entityliving = EntityFox.this.e();
            return entityliving != null && entityliving.bX() && cH.test(entityliving) && EntityFox.this.g((Entity)entityliving) > 36.0 && !EntityFox.this.cu() && !EntityFox.this.gL() && !EntityFox.this.bL;
        }

        @Override
        public void d() {
            EntityFox.this.x(false);
            EntityFox.this.B(false);
        }

        @Override
        public void e() {
            EntityLiving entityliving = EntityFox.this.e();
            if (entityliving != null && EntityFox.a(EntityFox.this, entityliving)) {
                EntityFox.this.A(true);
                EntityFox.this.z(true);
                EntityFox.this.S().n();
                EntityFox.this.P().a(entityliving, (float)EntityFox.this.ah(), (float)EntityFox.this.af());
            } else {
                EntityFox.this.A(false);
                EntityFox.this.z(false);
            }
        }

        @Override
        public void a() {
            EntityLiving entityliving = EntityFox.this.e();
            if (entityliving != null) {
                EntityFox.this.P().a(entityliving, (float)EntityFox.this.ah(), (float)EntityFox.this.af());
                if (EntityFox.this.g((Entity)entityliving) <= 36.0) {
                    EntityFox.this.A(true);
                    EntityFox.this.z(true);
                    EntityFox.this.S().n();
                } else {
                    EntityFox.this.S().a((Entity)entityliving, 1.5);
                }
            }
        }
    }

    public class o
    extends PathfinderGoalWaterJumpAbstract {
        @Override
        public boolean b() {
            if (!EntityFox.this.gK()) {
                return false;
            }
            EntityLiving entityliving = EntityFox.this.e();
            if (entityliving != null && entityliving.bX()) {
                if (entityliving.dc() != entityliving.db()) {
                    return false;
                }
                boolean flag = EntityFox.a(EntityFox.this, entityliving);
                if (!flag) {
                    EntityFox.this.S().a((Entity)entityliving, 0);
                    EntityFox.this.z(false);
                    EntityFox.this.A(false);
                }
                return flag;
            }
            return false;
        }

        @Override
        public boolean c() {
            EntityLiving entityliving = EntityFox.this.e();
            if (entityliving != null && entityliving.bX()) {
                double d0 = EntityFox.this.dI().h;
                return (d0 * d0 >= (double)0.05f || Math.abs(EntityFox.this.dZ()) >= 15.0f || !EntityFox.this.aS()) && !EntityFox.this.gI();
            }
            return false;
        }

        @Override
        public boolean X_() {
            return false;
        }

        @Override
        public void d() {
            EntityFox.this.t(true);
            EntityFox.this.y(true);
            EntityFox.this.A(false);
            EntityLiving entityliving = EntityFox.this.e();
            if (entityliving != null) {
                EntityFox.this.P().a(entityliving, 60.0f, 30.0f);
                Vec3D vec3d = new Vec3D(entityliving.dK() - EntityFox.this.dK(), entityliving.dM() - EntityFox.this.dM(), entityliving.dQ() - EntityFox.this.dQ()).d();
                EntityFox.this.k(EntityFox.this.dI().b(vec3d.g * 0.8, 0.9, vec3d.i * 0.8));
            }
            EntityFox.this.S().n();
        }

        @Override
        public void e() {
            EntityFox.this.z(false);
            EntityFox.this.cW = 0.0f;
            EntityFox.this.cX = 0.0f;
            EntityFox.this.A(false);
            EntityFox.this.y(false);
        }

        @Override
        public void a() {
            EntityLiving entityliving = EntityFox.this.e();
            if (entityliving != null) {
                EntityFox.this.P().a(entityliving, 60.0f, 30.0f);
            }
            if (!EntityFox.this.gI()) {
                Vec3D vec3d = EntityFox.this.dI();
                if (vec3d.h * vec3d.h < (double)0.03f && EntityFox.this.dZ() != 0.0f) {
                    EntityFox.this.w(MathHelper.i(0.2f, EntityFox.this.dZ(), 0.0f));
                } else {
                    double d0 = vec3d.i();
                    double d1 = Math.signum(-vec3d.h) * Math.acos(d0 / vec3d.g()) * 57.2957763671875;
                    EntityFox.this.w((float)d1);
                }
            }
            if (entityliving != null && EntityFox.this.f((Entity)entityliving) <= 2.0f) {
                EntityFox.this.c(o.a(EntityFox.this.an()), (Entity)entityliving);
            } else if (EntityFox.this.dZ() > 0.0f && EntityFox.this.aS() && (float)EntityFox.this.dI().h != 0.0f && EntityFox.this.an().a_(EntityFox.this.dF()).a(Blocks.ep)) {
                EntityFox.this.w(60.0f);
                EntityFox.this.g((EntityLiving)null);
                EntityFox.this.B(true);
            }
        }
    }

    private class s
    extends PathfinderGoalFleeSun {
        private int c;

        public s(double d0) {
            super(EntityFox.this, d0);
            this.c = net.minecraft.world.entity.animal.EntityFox$s.b(100);
        }

        @Override
        public boolean b() {
            if (!EntityFox.this.gg() && this.a.e() == null) {
                if (EntityFox.this.an().ai() && EntityFox.this.an().h(this.a.dF())) {
                    return this.h();
                }
                if (this.c > 0) {
                    --this.c;
                    return false;
                }
                this.c = 100;
                BlockPosition blockposition = this.a.dF();
                return EntityFox.this.an().aa() && EntityFox.this.an().h(blockposition) && !((WorldServer)EntityFox.this.an()).c(blockposition) && this.h();
            }
            return false;
        }

        @Override
        public void d() {
            EntityFox.this.gY();
            super.d();
        }
    }

    private class l
    extends PathfinderGoalMeleeAttack {
        public l(double d0, boolean flag) {
            super(EntityFox.this, d0, flag);
        }

        @Override
        protected void a(EntityLiving entityliving) {
            if (this.b(entityliving)) {
                this.h();
                this.a.c(l.a(this.a), (Entity)entityliving);
                EntityFox.this.a(SoundEffects.kz, 1.0f, 1.0f);
            }
        }

        @Override
        public void d() {
            EntityFox.this.A(false);
            super.d();
        }

        @Override
        public boolean b() {
            return !EntityFox.this.s() && !EntityFox.this.gg() && !EntityFox.this.cu() && !EntityFox.this.gI() && super.b();
        }
    }

    private class t
    extends d {
        private static final int c = net.minecraft.world.entity.animal.EntityFox$t.b(140);
        private int d;

        public t() {
            this.d = EntityFox.this.as.a(c);
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b, PathfinderGoal.Type.c));
        }

        @Override
        public boolean b() {
            return EntityFox.this.bM == 0.0f && EntityFox.this.bN == 0.0f && EntityFox.this.bO == 0.0f ? this.k() || EntityFox.this.gg() : false;
        }

        @Override
        public boolean c() {
            return this.k();
        }

        private boolean k() {
            if (this.d > 0) {
                --this.d;
                return false;
            }
            return EntityFox.this.an().aa() && this.h() && !this.i() && !EntityFox.this.aJ;
        }

        @Override
        public void e() {
            this.d = EntityFox.this.as.a(c);
            EntityFox.this.gY();
        }

        @Override
        public void d() {
            EntityFox.this.x(false);
            EntityFox.this.z(false);
            EntityFox.this.A(false);
            EntityFox.this.t(false);
            EntityFox.this.D(true);
            EntityFox.this.S().n();
            EntityFox.this.Q().a(EntityFox.this.dK(), EntityFox.this.dM(), EntityFox.this.dQ(), 0.0);
        }
    }

    private static class h
    extends PathfinderGoalFollowParent {
        private final EntityFox d;

        public h(EntityFox entityfox, double d0) {
            super(entityfox, d0);
            this.d = entityfox;
        }

        @Override
        public boolean b() {
            return !this.d.gW() && super.b();
        }

        @Override
        public boolean c() {
            return !this.d.gW() && super.c();
        }

        @Override
        public void d() {
            this.d.gY();
            super.d();
        }
    }

    private class q
    extends PathfinderGoalNearestVillage {
        public q(int i2, int j2) {
            super(EntityFox.this, j2);
        }

        @Override
        public void d() {
            EntityFox.this.gY();
            super.d();
        }

        @Override
        public boolean b() {
            return super.b() && this.h();
        }

        @Override
        public boolean c() {
            return super.c() && this.h();
        }

        private boolean h() {
            return !EntityFox.this.gg() && !EntityFox.this.s() && !EntityFox.this.gW() && EntityFox.this.e() == null;
        }
    }

    public class f
    extends PathfinderGoalGotoTarget {
        private static final int i = 40;
        protected int g;

        public f(double d0, int i2, int j2) {
            super(EntityFox.this, d0, i2, j2);
        }

        @Override
        public double i() {
            return 2.0;
        }

        @Override
        public boolean l() {
            return this.d % 100 == 0;
        }

        @Override
        protected boolean a(IWorldReader iworldreader, BlockPosition blockposition) {
            IBlockData iblockdata = iworldreader.a_(blockposition);
            return iblockdata.a(Blocks.pg) && iblockdata.c(BlockSweetBerryBush.c) >= 2 || CaveVines.j_(iblockdata);
        }

        @Override
        public void a() {
            if (this.m()) {
                if (this.g >= 40) {
                    this.o();
                } else {
                    ++this.g;
                }
            } else if (!this.m() && EntityFox.this.as.i() < 0.05f) {
                EntityFox.this.a(SoundEffects.kF, 1.0f, 1.0f);
            }
            super.a();
        }

        protected void o() {
            if (net.minecraft.world.entity.animal.EntityFox$f.a(EntityFox.this.an()).S().c(GameRules.d)) {
                IBlockData iblockdata = EntityFox.this.an().a_(this.e);
                if (iblockdata.a(Blocks.pg)) {
                    this.b(iblockdata);
                } else if (CaveVines.j_(iblockdata)) {
                    this.a(iblockdata);
                }
            }
        }

        private void a(IBlockData iblockdata) {
            CaveVines.a(EntityFox.this, iblockdata, EntityFox.this.an(), this.e);
        }

        private void b(IBlockData iblockdata) {
            int i2 = iblockdata.c(BlockSweetBerryBush.c);
            iblockdata.b(BlockSweetBerryBush.c, 1);
            if (!CraftEventFactory.callEntityChangeBlockEvent(EntityFox.this, this.e, (IBlockData)iblockdata.b(BlockSweetBerryBush.c, 1))) {
                return;
            }
            int j2 = 1 + EntityFox.this.an().z.a(2) + (i2 == 3 ? 1 : 0);
            ItemStack itemstack = EntityFox.this.a(EnumItemSlot.a);
            if (itemstack.f()) {
                EntityFox.this.a(EnumItemSlot.a, new ItemStack(Items.yJ));
                --j2;
            }
            if (j2 > 0) {
                Block.a(EntityFox.this.an(), this.e, new ItemStack(Items.yJ, j2));
            }
            EntityFox.this.a(SoundEffects.BL, 1.0f, 1.0f);
            EntityFox.this.an().a(this.e, (IBlockData)iblockdata.b(BlockSweetBerryBush.c, 1), 2);
            EntityFox.this.an().a(GameEvent.c, this.e, GameEvent.a.a(EntityFox.this));
        }

        @Override
        public boolean b() {
            return !EntityFox.this.gg() && super.b();
        }

        @Override
        public void d() {
            this.g = 0;
            EntityFox.this.x(false);
            super.d();
        }
    }

    private class p
    extends PathfinderGoal {
        public p() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            if (!EntityFox.this.a(EnumItemSlot.a).f()) {
                return false;
            }
            if (EntityFox.this.e() == null && EntityFox.this.eF() == null) {
                if (!EntityFox.this.gZ()) {
                    return false;
                }
                if (EntityFox.this.ek().a(p.b(10)) != 0) {
                    return false;
                }
                List<EntityItem> list = EntityFox.this.an().a(EntityItem.class, EntityFox.this.de().c(8.0, 8.0, 8.0), cF);
                return !list.isEmpty() && EntityFox.this.a(EnumItemSlot.a).f();
            }
            return false;
        }

        @Override
        public void a() {
            List<EntityItem> list = EntityFox.this.an().a(EntityItem.class, EntityFox.this.de().c(8.0, 8.0, 8.0), cF);
            ItemStack itemstack = EntityFox.this.a(EnumItemSlot.a);
            if (itemstack.f() && !list.isEmpty()) {
                EntityFox.this.S().a((Entity)list.get(0), (double)1.2f);
            }
        }

        @Override
        public void d() {
            List<EntityItem> list = EntityFox.this.an().a(EntityItem.class, EntityFox.this.de().c(8.0, 8.0, 8.0), cF);
            if (!list.isEmpty()) {
                EntityFox.this.S().a((Entity)list.get(0), (double)1.2f);
            }
        }
    }

    private class j
    extends PathfinderGoalLookAtPlayer {
        public j(EntityInsentient entityinsentient, Class oclass, float f2) {
            super(entityinsentient, oclass, f2);
        }

        @Override
        public boolean b() {
            return super.b() && !EntityFox.this.gI() && !EntityFox.this.gL();
        }

        @Override
        public boolean c() {
            return super.c() && !EntityFox.this.gI() && !EntityFox.this.gL();
        }
    }

    private class r
    extends d {
        private double c;
        private double d;
        private int e;
        private int f;

        public r() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            return EntityFox.this.eF() == null && EntityFox.this.ek().i() < 0.02f && !EntityFox.this.gg() && EntityFox.this.e() == null && EntityFox.this.S().l() && !this.i() && !EntityFox.this.gJ() && !EntityFox.this.cu();
        }

        @Override
        public boolean c() {
            return this.f > 0;
        }

        @Override
        public void d() {
            this.k();
            this.f = 2 + EntityFox.this.ek().a(3);
            EntityFox.this.x(true);
            EntityFox.this.S().n();
        }

        @Override
        public void e() {
            EntityFox.this.x(false);
        }

        @Override
        public void a() {
            --this.e;
            if (this.e <= 0) {
                --this.f;
                this.k();
            }
            EntityFox.this.P().a(EntityFox.this.dK() + this.c, EntityFox.this.dO(), EntityFox.this.dQ() + this.d, EntityFox.this.ah(), EntityFox.this.af());
        }

        private void k() {
            double d0 = Math.PI * 2 * EntityFox.this.ek().j();
            this.c = Math.cos(d0);
            this.d = Math.sin(d0);
            this.e = this.a(80 + EntityFox.this.ek().a(20));
        }
    }

    private class a
    extends PathfinderGoalNearestAttackableTarget<EntityLiving> {
        @Nullable
        private EntityLiving j;
        @Nullable
        private EntityLiving k;
        private int l;

        public a(Class oclass, boolean flag, @Nullable boolean flag1, PathfinderTargetCondition.a pathfindertargetcondition_a) {
            super(EntityFox.this, oclass, 10, flag, flag1, pathfindertargetcondition_a);
        }

        @Override
        public boolean b() {
            if (this.b > 0 && this.e.ek().a(this.b) != 0) {
                return false;
            }
            WorldServer worldserver = net.minecraft.world.entity.animal.EntityFox$a.a(EntityFox.this.an());
            for (EntityReference<EntityLiving> entityreference : EntityFox.this.gU().toList()) {
                EntityLiving entityliving = entityreference.a(worldserver, EntityLiving.class);
                if (entityliving == null) continue;
                this.k = entityliving;
                this.j = entityliving.eF();
                int i2 = entityliving.eH();
                return i2 != this.l && this.a(this.j, this.d);
            }
            return false;
        }

        @Override
        public void d() {
            this.a(this.j);
            this.c = this.j;
            if (this.k != null) {
                this.l = this.k.eH();
            }
            EntityFox.this.a(SoundEffects.kx, 1.0f, 1.0f);
            EntityFox.this.C(true);
            EntityFox.this.gX();
            super.d();
        }
    }

    public static class i
    extends EntityAgeable.a {
        public final Type a;

        public i(Type entityfox_type) {
            super(false);
            this.a = entityfox_type;
        }
    }

    private abstract class d
    extends PathfinderGoal {
        private final PathfinderTargetCondition b;

        d() {
            this.b = PathfinderTargetCondition.a().a(12.0).d().a(new c());
        }

        protected boolean h() {
            BlockPosition blockposition = BlockPosition.a(EntityFox.this.dK(), EntityFox.this.de().e, EntityFox.this.dQ());
            return !EntityFox.this.an().h(blockposition) && EntityFox.this.c(blockposition) >= 0.0f;
        }

        protected boolean i() {
            return !net.minecraft.world.entity.animal.EntityFox$d.a(EntityFox.this.an()).a(EntityLiving.class, this.b, EntityFox.this, EntityFox.this.de().c(12.0, 6.0, 12.0)).isEmpty();
        }
    }

    public class c
    implements PathfinderTargetCondition.a {
        @Override
        public boolean test(EntityLiving entityliving, WorldServer worldserver) {
            if (entityliving instanceof EntityFox) {
                return false;
            }
            if (!(entityliving instanceof EntityChicken || entityliving instanceof EntityRabbit || entityliving instanceof EntityMonster)) {
                EntityHuman entityhuman;
                if (entityliving instanceof EntityTameableAnimal) {
                    return !((EntityTameableAnimal)entityliving).m();
                }
                if (entityliving instanceof EntityHuman && ((entityhuman = (EntityHuman)entityliving).at() || entityhuman.gQ())) {
                    return false;
                }
                if (EntityFox.this.j(entityliving)) {
                    return false;
                }
                return !entityliving.gg() && !entityliving.cs();
            }
            return true;
        }
    }
}

