/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowEntity;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPerch;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomFly;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.animal.EntityPerchable;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class EntityParrot
extends EntityPerchable
implements EntityBird {
    private static final DataWatcherObject<Integer> cB = DataWatcher.a(EntityParrot.class, DataWatcherRegistry.b);
    private static final Predicate<EntityInsentient> cC = new Predicate<EntityInsentient>(){

        public boolean a(@Nullable EntityInsentient entityinsentient) {
            return entityinsentient != null && cD.containsKey(entityinsentient.ax());
        }
    };
    static final Map<EntityTypes<?>, SoundEffect> cD = SystemUtils.a(Maps.newHashMap(), (? super T hashmap) -> {
        hashmap.put(EntityTypes.q, SoundEffects.uC);
        hashmap.put(EntityTypes.s, SoundEffects.uD);
        hashmap.put(EntityTypes.t, SoundEffects.uE);
        hashmap.put(EntityTypes.x, SoundEffects.vb);
        hashmap.put(EntityTypes.G, SoundEffects.uF);
        hashmap.put(EntityTypes.H, SoundEffects.uG);
        hashmap.put(EntityTypes.N, SoundEffects.uH);
        hashmap.put(EntityTypes.P, SoundEffects.uI);
        hashmap.put(EntityTypes.S, SoundEffects.uJ);
        hashmap.put(EntityTypes.R, SoundEffects.uK);
        hashmap.put(EntityTypes.V, SoundEffects.uL);
        hashmap.put(EntityTypes.ag, SoundEffects.uM);
        hashmap.put(EntityTypes.ah, SoundEffects.sP);
        hashmap.put(EntityTypes.am, SoundEffects.uN);
        hashmap.put(EntityTypes.an, SoundEffects.uO);
        hashmap.put(EntityTypes.aq, SoundEffects.uP);
        hashmap.put(EntityTypes.ar, SoundEffects.uQ);
        hashmap.put(EntityTypes.aD, SoundEffects.uR);
        hashmap.put(EntityTypes.aU, SoundEffects.uS);
        hashmap.put(EntityTypes.aW, SoundEffects.uT);
        hashmap.put(EntityTypes.aX, SoundEffects.uU);
        hashmap.put(EntityTypes.aY, SoundEffects.uV);
        hashmap.put(EntityTypes.be, SoundEffects.uW);
        hashmap.put(EntityTypes.bh, SoundEffects.uX);
        hashmap.put(EntityTypes.bj, SoundEffects.uY);
        hashmap.put(EntityTypes.bk, SoundEffects.uZ);
        hashmap.put(EntityTypes.bm, SoundEffects.va);
        hashmap.put(EntityTypes.bt, SoundEffects.vb);
        hashmap.put(EntityTypes.bx, SoundEffects.vc);
        hashmap.put(EntityTypes.bH, SoundEffects.vd);
        hashmap.put(EntityTypes.bJ, SoundEffects.ve);
        hashmap.put(EntityTypes.bL, SoundEffects.vf);
        hashmap.put(EntityTypes.bN, SoundEffects.vg);
        hashmap.put(EntityTypes.bO, SoundEffects.vh);
        hashmap.put(EntityTypes.bP, SoundEffects.vi);
        hashmap.put(EntityTypes.bS, SoundEffects.vj);
        hashmap.put(EntityTypes.bT, SoundEffects.vk);
        hashmap.put(EntityTypes.bV, SoundEffects.vl);
    });
    public float cx;
    public float cy;
    public float cz;
    public float cA;
    private float cE = 1.0f;
    private float cF = 1.0f;
    private boolean cG;
    @Nullable
    private BlockPosition cH;

    public EntityParrot(EntityTypes<? extends EntityParrot> entitytypes, World world) {
        super((EntityTypes<? extends EntityPerchable>)entitytypes, world);
        this.cn = new ControllerMoveFlying(this, 10, false);
        this.a(PathType.n, -1.0f);
        this.a(PathType.o, -1.0f);
        this.a(PathType.x, -1.0f);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        this.a(SystemUtils.a(Variant.values(), worldaccess.I_()));
        if (groupdataentity == null) {
            groupdataentity = new EntityAgeable.a(false);
        }
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    @Override
    public boolean g_() {
        return false;
    }

    @Override
    protected void H() {
        this.cq.a(0, new EntityTameableAnimal.a(1.25));
        this.cq.a(0, new PathfinderGoalFloat(this));
        this.cq.a(1, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cq.a(2, new PathfinderGoalSit(this));
        this.cq.a(2, new PathfinderGoalFollowOwner(this, 1.0, 5.0f, 1.0f));
        this.cq.a(2, new a(this, 1.0));
        this.cq.a(3, new PathfinderGoalPerch(this));
        this.cq.a(3, new PathfinderGoalFollowEntity(this, 1.0, 3.0f, 7.0f));
    }

    public static AttributeProvider.Builder gU() {
        return EntityAnimal.gN().a(GenericAttributes.t, 6.0).a(GenericAttributes.m, 0.4f).a(GenericAttributes.w, 0.2f).a(GenericAttributes.c, 3.0);
    }

    @Override
    protected NavigationAbstract b(World world) {
        NavigationFlying navigationflying = new NavigationFlying(this, world);
        navigationflying.e(false);
        navigationflying.a(true);
        return navigationflying;
    }

    @Override
    public void e_() {
        if (this.cH == null || !this.cH.a(this.dD(), 3.46) || !this.an().a_(this.cH).a(Blocks.ew)) {
            this.cG = false;
            this.cH = null;
        }
        if (this.an().z.a(400) == 0) {
            EntityParrot.a(this.an(), this);
        }
        super.e_();
        this.gZ();
    }

    @Override
    public void a(BlockPosition blockposition, boolean flag) {
        this.cH = blockposition;
        this.cG = flag;
    }

    public boolean gV() {
        return this.cG;
    }

    private void gZ() {
        this.cA = this.cx;
        this.cz = this.cy;
        this.cy += (float)(!this.aS() && !this.cl() ? 4 : -1) * 0.3f;
        this.cy = MathHelper.a(this.cy, 0.0f, 1.0f);
        if (!this.aS() && this.cE < 1.0f) {
            this.cE = 1.0f;
        }
        this.cE *= 0.9f;
        Vec3D vec3d = this.dI();
        if (!this.aS() && vec3d.h < 0.0) {
            this.k(vec3d.d(1.0, 0.6, 1.0));
        }
        this.cx += this.cE * 2.0f;
    }

    public static boolean a(World world, Entity entity) {
        if (entity.bX() && !entity.bm() && world.z.a(2) == 0) {
            EntityInsentient entityinsentient;
            List<EntityInsentient> list = world.a(EntityInsentient.class, entity.de().g(20.0), cC);
            if (!list.isEmpty() && !(entityinsentient = list.get(world.z.a(list.size()))).bm()) {
                SoundEffect soundeffect = EntityParrot.b(entityinsentient.ax());
                world.a((Entity)null, entity.dK(), entity.dM(), entity.dQ(), soundeffect, entity.dw(), 0.7f, EntityParrot.a(world.z));
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (!this.m() && itemstack.a(TagsItem.bd)) {
            this.a(entityhuman, enumhand, itemstack);
            if (!this.bm()) {
                this.an().a((Entity)null, this.dK(), this.dM(), this.dQ(), SoundEffects.uz, this.dw(), 1.0f, 1.0f + (this.as.i() - this.as.i()) * 0.2f);
            }
            if (!this.an().D_()) {
                if (this.as.a(10) == 0 && !CraftEventFactory.callEntityTameEvent(this, entityhuman).isCancelled()) {
                    this.g(entityhuman);
                    this.an().a((Entity)this, (byte)7);
                } else {
                    this.an().a((Entity)this, (byte)6);
                }
            }
            return EnumInteractionResult.a;
        }
        if (!itemstack.a(TagsItem.be)) {
            if (!this.gX() && this.m() && this.j(entityhuman)) {
                if (!this.an().D_()) {
                    this.z(!this.gI());
                }
                return EnumInteractionResult.a;
            }
            return super.b(entityhuman, enumhand);
        }
        this.a(entityhuman, enumhand, itemstack);
        this.addEffect(new MobEffect(MobEffects.s, 900), EntityPotionEffectEvent.Cause.FOOD);
        if (entityhuman.gQ() || !this.cP()) {
            this.a(this.ei().a(entityhuman), Float.MAX_VALUE);
        }
        return EnumInteractionResult.a;
    }

    @Override
    public boolean i(ItemStack itemstack) {
        return false;
    }

    public static boolean c(EntityTypes<EntityParrot> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        return generatoraccess.a_(blockposition.e()).a(TagsBlock.cp) && EntityParrot.a(generatoraccess, blockposition);
    }

    @Override
    protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
    }

    @Override
    public boolean a(EntityAnimal entityanimal) {
        return false;
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer worldserver, EntityAgeable entityageable) {
        return null;
    }

    @Override
    @Nullable
    public SoundEffect p() {
        return EntityParrot.a(this.an(), this.an().z);
    }

    public static SoundEffect a(World world, RandomSource randomsource) {
        if (world.aq() != EnumDifficulty.a && randomsource.a(1000) == 0) {
            ArrayList list = Lists.newArrayList(cD.keySet());
            return EntityParrot.b((EntityTypes)list.get(randomsource.a(list.size())));
        }
        return SoundEffects.ux;
    }

    private static SoundEffect b(EntityTypes<?> entitytypes) {
        return cD.getOrDefault(entitytypes, SoundEffects.ux);
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.uB;
    }

    @Override
    protected SoundEffect f_() {
        return SoundEffects.uy;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.vm, 0.15f, 1.0f);
    }

    @Override
    protected boolean bl() {
        return this.am > this.cF;
    }

    @Override
    protected void bk() {
        this.a(SoundEffects.uA, 0.15f, 1.0f);
        this.cF = this.am + this.cy / 2.0f;
    }

    @Override
    public float fu() {
        return EntityParrot.a(this.as);
    }

    public static float a(RandomSource randomsource) {
        return (randomsource.i() - randomsource.i()) * 0.2f + 1.0f;
    }

    @Override
    public SoundCategory dw() {
        return SoundCategory.g;
    }

    @Override
    public boolean bU() {
        return super.bU();
    }

    @Override
    protected void E(Entity entity) {
        if (!(entity instanceof EntityHuman)) {
            super.E(entity);
        }
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        if (this.a(worldserver, damagesource)) {
            return false;
        }
        boolean result = super.a(worldserver, damagesource, f2);
        if (!result) {
            return result;
        }
        this.z(false);
        return result;
    }

    public Variant gW() {
        return Variant.a(this.az.a(cB));
    }

    public void a(Variant entityparrot_variant) {
        this.az.a(cB, entityparrot_variant.k);
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.aB ? EntityParrot.c(datacomponenttype, this.gW()) : super.a(datacomponenttype);
    }

    @Override
    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.aB);
        super.a(datacomponentgetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.aB) {
            this.a(EntityParrot.c(DataComponents.aB, t0));
            return true;
        }
        return super.b(datacomponenttype, t0);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cB, Variant.f.k);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("Variant", Variant.h, this.gW());
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.a(valueinput.a("Variant", Variant.h).orElse(Variant.f));
    }

    @Override
    public boolean gX() {
        return !this.aS();
    }

    @Override
    protected boolean gM() {
        return true;
    }

    @Override
    public Vec3D F() {
        return new Vec3D(0.0, 0.5f * this.df(), this.dA() * 0.4f);
    }

    public static enum Variant implements INamable
    {
        a(0, "red_blue"),
        b(1, "blue"),
        c(2, "green"),
        d(3, "yellow_blue"),
        e(4, "gray");

        public static final Variant f;
        private static final IntFunction<Variant> j;
        public static final Codec<Variant> g;
        @Deprecated
        public static final Codec<Variant> h;
        public static final StreamCodec<ByteBuf, Variant> i;
        final int k;
        private final String l;

        private Variant(int i2, String s2) {
            this.k = i2;
            this.l = s2;
        }

        public int a() {
            return this.k;
        }

        public static Variant a(int i2) {
            return j.apply(i2);
        }

        @Override
        public String c() {
            return this.l;
        }

        static {
            f = a;
            j = ByIdMap.a(Variant::a, Variant.values(), ByIdMap.a.c);
            g = INamable.a(Variant::values);
            PrimitiveCodec primitivecodec = Codec.INT;
            IntFunction<Variant> intfunction = j;
            Objects.requireNonNull(intfunction);
            h = primitivecodec.xmap(intfunction::apply, Variant::a);
            i = ByteBufCodecs.a(j, Variant::a);
        }
    }

    private static class a
    extends PathfinderGoalRandomFly {
        public a(EntityCreature entitycreature, double d0) {
            super(entitycreature, d0);
        }

        @Override
        @Nullable
        protected Vec3D h() {
            Vec3D vec3d = null;
            if (this.b.bu()) {
                vec3d = LandRandomPos.a(this.b, 15, 15);
            }
            if (this.b.ek().i() >= this.j) {
                vec3d = this.k();
            }
            return vec3d == null ? super.h() : vec3d;
        }

        @Nullable
        private Vec3D k() {
            BlockPosition blockposition = this.b.dF();
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition1 = new BlockPosition.MutableBlockPosition();
            for (BlockPosition blockposition1 : BlockPosition.b(MathHelper.a(this.b.dK() - 3.0), MathHelper.a(this.b.dM() - 6.0), MathHelper.a(this.b.dQ() - 3.0), MathHelper.a(this.b.dK() + 3.0), MathHelper.a(this.b.dM() + 6.0), MathHelper.a(this.b.dQ() + 3.0))) {
                IBlockData iblockdata;
                boolean flag;
                if (blockposition.equals(blockposition1) || !(flag = (iblockdata = this.b.an().a_(blockposition_mutableblockposition1.a((BaseBlockPosition)blockposition1, EnumDirection.a))).b() instanceof BlockLeaves || iblockdata.a(TagsBlock.E)) || !this.b.an().w(blockposition1) || !this.b.an().w(blockposition_mutableblockposition.a((BaseBlockPosition)blockposition1, EnumDirection.b))) continue;
                return Vec3D.c(blockposition1);
            }
            return null;
        }
    }
}

