/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SpawnUtil;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.Behaviors;
import net.minecraft.world.entity.ai.gossip.Reputation;
import net.minecraft.world.entity.ai.gossip.ReputationType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorGolemLastSeen;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityWitch;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftVillager;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.VillagerReplenishTradeEvent;
import org.bukkit.inventory.MerchantRecipe;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class EntityVillager
extends EntityVillagerAbstract
implements ReputationHandler,
VillagerDataHolder {
    private static final Logger cz = LogUtils.getLogger();
    private static final DataWatcherObject<VillagerData> cA = DataWatcher.a(EntityVillager.class, DataWatcherRegistry.t);
    public static final int cv = 12;
    public static final Map<Item, Integer> cw = ImmutableMap.of((Object)Items.rd, (Object)4, (Object)Items.wo, (Object)1, (Object)Items.wn, (Object)1, (Object)Items.xu, (Object)1);
    private static final int cB = 2;
    private static final int cC = 10;
    private static final int cD = 1200;
    private static final int cE = 24000;
    private static final int cF = 10;
    private static final int cG = 5;
    private static final long cH = 24000L;
    @VisibleForTesting
    public static final float cx = 0.5f;
    private static final int cI = 0;
    private static final byte cJ = 0;
    private static final int cK = 0;
    private static final int cL = 0;
    private static final int cM = 0;
    private static final boolean cN = false;
    private int cO;
    private boolean cP;
    @Nullable
    private EntityHuman cS;
    private boolean cT;
    private int cU = 0;
    private final Reputation cV = new Reputation(this);
    private long cW;
    private long cX = 0L;
    private int cY = 0;
    private long cZ = 0L;
    private int da = 0;
    private long db;
    private boolean dc = false;
    private static final ImmutableList<MemoryModuleType<?>> dd = ImmutableList.of(MemoryModuleType.b, MemoryModuleType.c, MemoryModuleType.d, MemoryModuleType.e, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.i, MemoryModuleType.j, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.M, MemoryModuleType.aT, (Object[])new MemoryModuleType[]{MemoryModuleType.n, MemoryModuleType.o, MemoryModuleType.r, MemoryModuleType.s, MemoryModuleType.u, MemoryModuleType.w, MemoryModuleType.x, MemoryModuleType.y, MemoryModuleType.z, MemoryModuleType.B, MemoryModuleType.f, MemoryModuleType.D, MemoryModuleType.E, MemoryModuleType.F, MemoryModuleType.I, MemoryModuleType.J, MemoryModuleType.K, MemoryModuleType.G});
    private static final ImmutableList<SensorType<? extends Sensor<? super EntityVillager>>> de = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.e, SensorType.f, SensorType.g, SensorType.h, SensorType.i, SensorType.j);
    public static final Map<MemoryModuleType<GlobalPos>, BiPredicate<EntityVillager, Holder<VillagePlaceType>>> cy = ImmutableMap.of(MemoryModuleType.b, (entityvillager, holder) -> holder.a(PoiTypes.n), MemoryModuleType.c, (entityvillager, holder) -> entityvillager.gR().b().a().b().test((Holder<VillagePlaceType>)holder), MemoryModuleType.d, (entityvillager, holder) -> VillagerProfession.a.test((Holder<VillagePlaceType>)holder), MemoryModuleType.e, (entityvillager, holder) -> holder.a(PoiTypes.o));
    public long gossipDecayInterval = 24000L;

    public EntityVillager(EntityTypes<? extends EntityVillager> entitytypes, World world) {
        this(entitytypes, world, VillagerType.c);
    }

    public EntityVillager(EntityTypes<? extends EntityVillager> entitytypes, World world, ResourceKey<VillagerType> resourcekey) {
        this(entitytypes, world, world.L_().d(resourcekey));
    }

    public EntityVillager(EntityTypes<? extends EntityVillager> entitytypes, World world, Holder<VillagerType> holder) {
        super((EntityTypes<? extends EntityVillagerAbstract>)entitytypes, world);
        this.S().e(true);
        this.S().a(true);
        this.S().a(48.0f);
        this.a_(true);
        this.a(this.gR().a(holder).b(world.L_(), VillagerProfession.b));
    }

    public BehaviorController<EntityVillager> eq() {
        return super.eq();
    }

    protected BehaviorController.b<EntityVillager> er() {
        return BehaviorController.a(dd, de);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        BehaviorController<EntityVillager> behaviorcontroller = this.er().a(dynamic);
        this.a(behaviorcontroller);
        return behaviorcontroller;
    }

    public void h(WorldServer worldserver) {
        BehaviorController<EntityVillager> behaviorcontroller = this.eq();
        behaviorcontroller.b(worldserver, this);
        this.bY = behaviorcontroller.i();
        this.a(this.eq());
    }

    private void a(BehaviorController<EntityVillager> behaviorcontroller) {
        Holder<VillagerProfession> holder = this.gR().b();
        if (this.g_()) {
            behaviorcontroller.a(Schedule.e);
            behaviorcontroller.a(Activity.d, Behaviors.a(0.5f));
        } else {
            behaviorcontroller.a(Schedule.f);
            behaviorcontroller.a(Activity.c, (ImmutableList<Pair<Integer, BehaviorControl<EntityVillager>>>)Behaviors.b(holder, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.c, (Object)((Object)MemoryStatus.a))));
        }
        behaviorcontroller.a(Activity.a, Behaviors.a(holder, 0.5f));
        behaviorcontroller.a(Activity.f, (ImmutableList<Pair<Integer, BehaviorControl<EntityVillager>>>)Behaviors.d(holder, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.e, (Object)((Object)MemoryStatus.a))));
        behaviorcontroller.a(Activity.e, Behaviors.c(holder, 0.5f));
        behaviorcontroller.a(Activity.b, Behaviors.e(holder, 0.5f));
        behaviorcontroller.a(Activity.g, Behaviors.f(holder, 0.5f));
        behaviorcontroller.a(Activity.i, Behaviors.g(holder, 0.5f));
        behaviorcontroller.a(Activity.h, Behaviors.h(holder, 0.5f));
        behaviorcontroller.a(Activity.j, Behaviors.i(holder, 0.5f));
        behaviorcontroller.a((Set<Activity>)ImmutableSet.of((Object)Activity.a));
        behaviorcontroller.b(Activity.b);
        behaviorcontroller.a(Activity.b);
        behaviorcontroller.a(this.an().ah(), this.an().ag());
    }

    @Override
    protected void h() {
        super.h();
        if (this.an() instanceof WorldServer) {
            this.h((WorldServer)this.an());
        }
    }

    public static AttributeProvider.Builder gS() {
        return EntityInsentient.I().a(GenericAttributes.w, 0.5);
    }

    public boolean gT() {
        return this.dc;
    }

    @Override
    public void inactiveTick() {
        if (this.an().spigotConfig.tickInactiveVillagers && this.dt()) {
            this.a((WorldServer)this.an());
        }
        super.inactiveTick();
    }

    @Override
    protected void a(WorldServer worldserver) {
        Raid raid;
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("villagerBrain");
        this.eq().a(worldserver, this);
        gameprofilerfiller.c();
        if (this.dc) {
            this.dc = false;
        }
        if (!this.gJ() && this.cO > 0) {
            --this.cO;
            if (this.cO <= 0) {
                if (this.cP) {
                    this.hp();
                    this.cP = false;
                }
                this.addEffect(new MobEffect(MobEffects.j, 200, 0), EntityPotionEffectEvent.Cause.VILLAGER_TRADE);
            }
        }
        if (this.cS != null) {
            worldserver.a(ReputationEvent.e, (Entity)this.cS, this);
            worldserver.a((Entity)this, (byte)14);
            this.cS = null;
        }
        if (!this.gx() && this.as.a(100) == 0 && (raid = worldserver.d(this.dF())) != null && raid.r() && !raid.a()) {
            worldserver.a((Entity)this, (byte)42);
        }
        if (this.gR().b().a(VillagerProfession.b) && this.gJ()) {
            this.gO();
        }
        super.a(worldserver);
    }

    @Override
    public void g() {
        super.g();
        if (this.m() > 0) {
            this.r(this.m() - 1);
        }
        this.hr();
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (!itemstack.a(Items.vP) && this.bX() && !this.gJ() && !this.gg()) {
            if (this.g_()) {
                this.he();
                return EnumInteractionResult.a;
            }
            if (!this.an().D_()) {
                boolean flag = this.gK().isEmpty();
                if (enumhand == EnumHand.a) {
                    if (flag) {
                        this.he();
                    }
                    entityhuman.a(StatisticList.T);
                }
                if (flag) {
                    return EnumInteractionResult.c;
                }
                this.j(entityhuman);
            }
            return EnumInteractionResult.a;
        }
        return super.b(entityhuman, enumhand);
    }

    public void he() {
        this.r(40);
        if (!this.an().D_()) {
            this.b(SoundEffects.Dp);
        }
    }

    private void j(EntityHuman entityhuman) {
        this.k(entityhuman);
        this.g(entityhuman);
        this.a(entityhuman, this.S_(), this.gR().c());
    }

    @Override
    public void g(@Nullable EntityHuman entityhuman) {
        boolean flag = this.gI() != null && entityhuman == null;
        super.g(entityhuman);
        if (flag) {
            this.gO();
        }
    }

    @Override
    protected void gO() {
        super.gO();
        this.hf();
    }

    private void hf() {
        if (!this.an().D_()) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.gK()) {
                merchantrecipe.n();
            }
        }
    }

    @Override
    public boolean gU() {
        return true;
    }

    public void gV() {
        this.hk();
        for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.gK()) {
            VillagerReplenishTradeEvent event = new VillagerReplenishTradeEvent((AbstractVillager)((Villager)this.getBukkitEntity()), (MerchantRecipe)merchantrecipe.asBukkit());
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            merchantrecipe.j();
        }
        this.hg();
        this.cZ = this.an().ag();
        ++this.da;
    }

    private void hg() {
        MerchantRecipeList merchantrecipelist = this.gK();
        EntityHuman entityhuman = this.gI();
        if (entityhuman != null && !merchantrecipelist.isEmpty()) {
            entityhuman.a(entityhuman.cl.l, merchantrecipelist, this.gR().c(), this.s(), this.gL(), this.gU());
        }
    }

    private boolean hh() {
        for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.gK()) {
            if (!merchantrecipe.t()) continue;
            return true;
        }
        return false;
    }

    private boolean hi() {
        return this.da == 0 || this.da < 2 && this.an().ag() > this.cZ + 2400L;
    }

    public boolean gW() {
        long i2 = this.cZ + 12000L;
        long j2 = this.an().ag();
        boolean flag = j2 > i2;
        long k2 = this.an().ah();
        if (this.db > 0L) {
            long i1 = k2 / 24000L;
            long l2 = this.db / 24000L;
            flag |= i1 > l2;
        }
        this.db = k2;
        if (flag) {
            this.cZ = j2;
            this.hs();
        }
        return this.hi() && this.hh();
    }

    private void hj() {
        int i2 = 2 - this.da;
        if (i2 > 0) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.gK()) {
                VillagerReplenishTradeEvent event = new VillagerReplenishTradeEvent((AbstractVillager)((Villager)this.getBukkitEntity()), (MerchantRecipe)merchantrecipe.asBukkit());
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                merchantrecipe.j();
            }
        }
        for (int j2 = 0; j2 < i2; ++j2) {
            this.hk();
        }
        this.hg();
    }

    private void hk() {
        for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.gK()) {
            merchantrecipe.g();
        }
    }

    private void k(EntityHuman entityhuman) {
        int i2 = this.i(entityhuman);
        if (i2 != 0) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.gK()) {
                merchantrecipe.a(-MathHelper.d((float)i2 * merchantrecipe.p()));
            }
        }
        if (entityhuman.d(MobEffects.F)) {
            MobEffect mobeffect = entityhuman.e(MobEffects.F);
            int j2 = mobeffect.e();
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe1 : this.gK()) {
                double d0 = 0.3 + 0.0625 * (double)j2;
                int k2 = (int)Math.floor(d0 * (double)merchantrecipe1.a().M());
                merchantrecipe1.a(-Math.max(k2, 1));
            }
        }
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cA, EntityVillager.gX());
    }

    public static VillagerData gX() {
        return new VillagerData(BuiltInRegistries.x.b(VillagerType.c), BuiltInRegistries.y.b(VillagerProfession.b), 1);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("VillagerData", VillagerData.c, this.gR());
        valueoutput.a("FoodLevel", (byte)this.cU);
        valueoutput.a("Gossips", Reputation.a, this.cV);
        valueoutput.a("Xp", this.cY);
        valueoutput.a("LastRestock", this.cZ);
        valueoutput.a("LastGossipDecay", this.cX);
        valueoutput.a("RestocksToday", this.da);
        if (this.dc) {
            valueoutput.a("AssignProfessionWhenSpawned", true);
        }
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.az.a(cA, valueinput.a("VillagerData", VillagerData.c).orElseGet(EntityVillager::gX));
        this.cU = valueinput.a("FoodLevel", (byte)0);
        this.cV.c();
        Optional<Reputation> optional = valueinput.a("Gossips", Reputation.a);
        Reputation reputation = this.cV;
        Objects.requireNonNull(this.cV);
        optional.ifPresent(reputation::a);
        this.cY = valueinput.a("Xp", 0);
        this.cZ = valueinput.a("LastRestock", 0L);
        this.cX = valueinput.a("LastGossipDecay", 0L);
        if (this.an() instanceof WorldServer) {
            this.h((WorldServer)this.an());
        }
        this.da = valueinput.a("RestocksToday", 0);
        this.dc = valueinput.a("AssignProfessionWhenSpawned", false);
    }

    @Override
    public boolean i(double d0) {
        return false;
    }

    @Override
    @Nullable
    protected SoundEffect p() {
        return this.gg() ? null : (this.gJ() ? SoundEffects.Dq : SoundEffects.Dl);
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.Do;
    }

    @Override
    protected SoundEffect f_() {
        return SoundEffects.Dn;
    }

    public void gY() {
        this.b(this.gR().b().a().f());
    }

    @Override
    public void a(VillagerData villagerdata) {
        VillagerData villagerdata1 = this.gR();
        if (!villagerdata1.b().equals(villagerdata.b())) {
            this.cu = null;
        }
        this.az.a(cA, villagerdata);
    }

    @Override
    public VillagerData gR() {
        return this.az.a(cA);
    }

    @Override
    protected void b(net.minecraft.world.item.trading.MerchantRecipe merchantrecipe) {
        int i2 = 3 + this.as.a(4);
        this.cY += merchantrecipe.q();
        this.cS = this.gI();
        if (this.ho()) {
            this.cO = 40;
            this.cP = true;
            i2 += 5;
        }
        if (merchantrecipe.u()) {
            this.an().b(new EntityExperienceOrb(this.an(), this.dK(), this.dM() + 0.5, this.dQ(), i2));
        }
    }

    @Override
    public void a(@Nullable EntityLiving entityliving) {
        if (entityliving != null && this.an() instanceof WorldServer) {
            ((WorldServer)this.an()).a(ReputationEvent.c, (Entity)entityliving, this);
            if (this.bX() && entityliving instanceof EntityHuman) {
                this.an().a((Entity)this, (byte)13);
            }
        }
        super.a(entityliving);
    }

    @Override
    public void a(DamageSource damagesource) {
        Entity entity;
        if (SpigotConfig.logVillagerDeaths) {
            cz.info("Villager {} died, message: '{}'", (Object)this, (Object)damagesource.a(this).getString());
        }
        if ((entity = damagesource.d()) != null) {
            this.G(entity);
        }
        this.hl();
        super.a(damagesource);
    }

    public void hl() {
        this.a(MemoryModuleType.b);
        this.a(MemoryModuleType.c);
        this.a(MemoryModuleType.d);
        this.a(MemoryModuleType.e);
    }

    private void G(Entity entity) {
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            Optional<NearestVisibleLivingEntities> optional = this.bY.c(MemoryModuleType.h);
            if (!optional.isEmpty()) {
                NearestVisibleLivingEntities nearestvisiblelivingentities = optional.get();
                Objects.requireNonNull(ReputationHandler.class);
                nearestvisiblelivingentities.b(ReputationHandler.class::isInstance).forEach(entityliving -> worldserver.a(ReputationEvent.d, entity, (ReputationHandler)((Object)entityliving)));
            }
        }
    }

    public void a(MemoryModuleType<GlobalPos> memorymoduletype) {
        if (this.an() instanceof WorldServer) {
            MinecraftServer minecraftserver = ((WorldServer)this.an()).q();
            this.bY.c(memorymoduletype).ifPresent(globalpos -> {
                WorldServer worldserver = minecraftserver.a(globalpos.a());
                if (worldserver != null) {
                    VillagePlace villageplace = worldserver.D();
                    Optional<Holder<VillagePlaceType>> optional = villageplace.c(globalpos.b());
                    BiPredicate<EntityVillager, Holder<VillagePlaceType>> bipredicate = cy.get(memorymoduletype);
                    if (optional.isPresent() && bipredicate.test(this, optional.get())) {
                        villageplace.b(globalpos.b());
                        worldserver.U().b(globalpos.b());
                    }
                }
            });
        }
    }

    @Override
    public boolean Z_() {
        return this.cU + this.hq() >= 12 && !this.gg() && this.aa_() == 0;
    }

    private boolean hm() {
        return this.cU < 12;
    }

    private void hn() {
        if (this.hm() && this.hq() != 0) {
            for (int i2 = 0; i2 < this.n().b(); ++i2) {
                int j2;
                Integer integer;
                ItemStack itemstack = this.n().a(i2);
                if (itemstack.f() || (integer = cw.get(itemstack.h())) == null) continue;
                for (int k2 = j2 = itemstack.M(); k2 > 0; --k2) {
                    this.cU += integer.intValue();
                    this.n().a(i2, 1);
                    if (this.hm()) continue;
                    return;
                }
            }
        }
    }

    public int i(EntityHuman entityhuman) {
        return this.cV.a(entityhuman.cT(), (ReputationType reputationtype) -> true);
    }

    private void u(int i2) {
        this.cU -= i2;
    }

    public void gZ() {
        this.hn();
        this.u(12);
    }

    public void b(MerchantRecipeList merchantrecipelist) {
        this.cu = merchantrecipelist;
    }

    private boolean ho() {
        int i2 = this.gR().c();
        return VillagerData.d(i2) && this.cY >= VillagerData.c(i2);
    }

    public void hp() {
        this.a(this.gR().a(this.gR().c() + 1));
        this.gP();
    }

    @Override
    protected IChatBaseComponent cM() {
        return this.gR().b().a().a();
    }

    @Override
    public void b(byte b0) {
        if (b0 == 12) {
            this.a(Particles.T);
        } else if (b0 == 13) {
            this.a(Particles.a);
        } else if (b0 == 14) {
            this.a(Particles.R);
        } else if (b0 == 42) {
            this.a(Particles.aq);
        } else {
            super.b(b0);
        }
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        if (entityspawnreason == EntitySpawnReason.e) {
            this.a(this.gR().b(worldaccess.L_(), VillagerProfession.b));
        }
        if (entityspawnreason == EntitySpawnReason.n || entityspawnreason == EntitySpawnReason.m || EntitySpawnReason.a(entityspawnreason) || entityspawnreason == EntitySpawnReason.o) {
            this.a(this.gR().a(worldaccess.L_(), VillagerType.a(worldaccess.v(this.dF()))));
        }
        if (entityspawnreason == EntitySpawnReason.d) {
            this.dc = true;
        }
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    @Nullable
    public EntityVillager b(WorldServer worldserver, EntityAgeable entityageable) {
        double d0 = this.as.j();
        Holder<VillagerType> holder = d0 < 0.5 ? worldserver.L_().d(VillagerType.a(worldserver.v(this.dF()))) : (d0 < 0.75 ? this.gR().a() : ((EntityVillager)entityageable).gR().a());
        EntityVillager entityvillager = new EntityVillager(EntityTypes.bI, (World)worldserver, holder);
        entityvillager.a((WorldAccess)worldserver, worldserver.d_(entityvillager.dF()), EntitySpawnReason.e, (GroupDataEntity)null);
        return entityvillager;
    }

    @Override
    public void a(WorldServer worldserver, EntityLightning entitylightning) {
        if (worldserver.aq() != EnumDifficulty.a) {
            cz.info("Villager {} was struck by lightning {}.", (Object)this, (Object)entitylightning);
            EntityWitch entitywitch = this.convertTo(EntityTypes.bN, ConversionParams.a(this, false, false), entitywitch1 -> {
                entitywitch1.a((WorldAccess)worldserver, worldserver.d_(entitywitch1.dF()), EntitySpawnReason.i, (GroupDataEntity)null);
                entitywitch1.gq();
                this.hl();
            }, EntityTransformEvent.TransformReason.LIGHTNING, CreatureSpawnEvent.SpawnReason.LIGHTNING);
            if (entitywitch == null) {
                super.a(worldserver, entitylightning);
            }
        } else {
            super.a(worldserver, entitylightning);
        }
    }

    @Override
    protected void a(WorldServer worldserver, EntityItem entityitem) {
        InventoryCarrier.a(worldserver, this, this, entityitem);
    }

    @Override
    public boolean c(WorldServer worldserver, ItemStack itemstack) {
        Item item = itemstack.h();
        return (itemstack.a(TagsItem.cc) || this.gR().b().a().d().contains((Object)item)) && this.n().c(itemstack);
    }

    public boolean ha() {
        return this.hq() >= 24;
    }

    public boolean hb() {
        return this.hq() < 12;
    }

    private int hq() {
        InventorySubcontainer inventorysubcontainer = this.n();
        return cw.entrySet().stream().mapToInt(entry -> inventorysubcontainer.a_((Item)entry.getKey()) * (Integer)entry.getValue()).sum();
    }

    public boolean hc() {
        return this.n().a_((ItemStack itemstack) -> itemstack.a(TagsItem.cb));
    }

    @Override
    protected void gP() {
        VillagerTrades.IMerchantRecipeOption[] avillagertrades_imerchantrecipeoption;
        Int2ObjectMap<VillagerTrades.IMerchantRecipeOption[]> int2objectmap1;
        Int2ObjectMap<VillagerTrades.IMerchantRecipeOption[]> int2objectmap;
        VillagerData villagerdata = this.gR();
        ResourceKey resourcekey = villagerdata.b().e().orElse(null);
        if (resourcekey != null && (int2objectmap = this.an().O().b(FeatureFlags.b) ? ((int2objectmap1 = VillagerTrades.c.get(resourcekey)) != null ? int2objectmap1 : VillagerTrades.a.get(resourcekey)) : VillagerTrades.a.get(resourcekey)) != null && !int2objectmap.isEmpty() && (avillagertrades_imerchantrecipeoption = (VillagerTrades.IMerchantRecipeOption[])int2objectmap.get(villagerdata.c())) != null) {
            MerchantRecipeList merchantrecipelist = this.gK();
            this.a(merchantrecipelist, avillagertrades_imerchantrecipeoption, 2);
            if (SharedConstants.an && villagerdata.c() < int2objectmap.size()) {
                this.hp();
            }
        }
    }

    public void a(WorldServer worldserver, EntityVillager entityvillager, long i2) {
        if (!(i2 >= this.cW && i2 < this.cW + 1200L || i2 >= entityvillager.cW && i2 < entityvillager.cW + 1200L)) {
            this.cV.a(entityvillager.cV, this.as, 10);
            this.cW = i2;
            entityvillager.cW = i2;
            this.a(worldserver, i2, 5);
        }
    }

    private void hr() {
        long i2 = this.an().ag();
        if (this.cX == 0L) {
            this.cX = i2;
        } else if (i2 >= this.cX + this.gossipDecayInterval) {
            this.cV.b();
            this.cX = i2;
        }
    }

    public void a(WorldServer worldserver, long i2, int j2) {
        AxisAlignedBB axisalignedbb;
        List<EntityVillager> list;
        List<EntityVillager> list1;
        if (this.a(i2) && (list1 = (list = worldserver.a(EntityVillager.class, axisalignedbb = this.de().c(10.0, 10.0, 10.0))).stream().filter(entityvillager -> entityvillager.a(i2)).limit(5L).toList()).size() >= j2 && !SpawnUtil.trySpawnMob(EntityTypes.at, EntitySpawnReason.f, worldserver, this.dF(), 10, 8, 6, SpawnUtil.a.a, false, CreatureSpawnEvent.SpawnReason.VILLAGE_DEFENSE).isEmpty()) {
            list.forEach(SensorGolemLastSeen::b);
        }
    }

    public boolean a(long i2) {
        return !this.b(this.an().ag()) ? false : !this.bY.a(MemoryModuleType.G);
    }

    @Override
    public void a(ReputationEvent reputationevent, Entity entity) {
        Villager.ReputationEvent bukkitReputationEvent = CraftVillager.CraftReputationEvent.minecraftToBukkit(reputationevent);
        if (reputationevent == ReputationEvent.a) {
            this.cV.add(entity.cT(), ReputationType.d, 20, bukkitReputationEvent);
            this.cV.add(entity.cT(), ReputationType.c, 25, bukkitReputationEvent);
        } else if (reputationevent == ReputationEvent.e) {
            this.cV.add(entity.cT(), ReputationType.e, 2, bukkitReputationEvent);
        } else if (reputationevent == ReputationEvent.c) {
            this.cV.add(entity.cT(), ReputationType.b, 25, bukkitReputationEvent);
        } else if (reputationevent == ReputationEvent.d) {
            this.cV.add(entity.cT(), ReputationType.a, 25, bukkitReputationEvent);
        }
    }

    @Override
    public int s() {
        return this.cY;
    }

    public void t(int i2) {
        this.cY = i2;
    }

    private void hs() {
        this.hj();
        this.da = 0;
    }

    public Reputation hd() {
        return this.cV;
    }

    public void a(Reputation reputation) {
        this.cV.a(reputation);
    }

    @Override
    public void b(BlockPosition blockposition) {
        super.b(blockposition);
        this.bY.a(MemoryModuleType.I, Long.valueOf(this.an().ag()));
        this.bY.b(MemoryModuleType.n);
        this.bY.b(MemoryModuleType.F);
    }

    @Override
    public void gh() {
        super.gh();
        this.bY.a(MemoryModuleType.J, Long.valueOf(this.an().ag()));
    }

    private boolean b(long i2) {
        Optional<Long> optional = this.bY.c(MemoryModuleType.I);
        return optional.filter(olong -> i2 - olong < 24000L).isPresent();
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.av ? EntityVillager.c(datacomponenttype, this.gR().a()) : super.a(datacomponenttype);
    }

    @Override
    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.av);
        super.a(datacomponentgetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.av) {
            Holder<VillagerType> holder = EntityVillager.c(DataComponents.av, t0);
            this.a(this.gR().a(holder));
            return true;
        }
        return super.b(datacomponenttype, t0);
    }
}

