/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.IMaterial;

public final class RecipeItemStack
implements AutoRecipeStackManager.a<Holder<Item>>,
Predicate<ItemStack> {
    public static final StreamCodec<RegistryFriendlyByteBuf, RecipeItemStack> a = ByteBufCodecs.c(Registries.O).a(RecipeItemStack::new, recipeitemstack -> recipeitemstack.e);
    public static final StreamCodec<RegistryFriendlyByteBuf, Optional<RecipeItemStack>> b = ByteBufCodecs.c(Registries.O).a(holderset -> holderset.b() == 0 ? Optional.empty() : Optional.of(new RecipeItemStack((HolderSet<Item>)holderset)), optional -> optional.map(recipeitemstack -> recipeitemstack.e).orElse(HolderSet.a(new Holder[0])));
    public static final Codec<HolderSet<Item>> c = HolderSetCodec.a(Registries.O, Item.e, false);
    public static final Codec<RecipeItemStack> d = ExtraCodecs.c(c).xmap(RecipeItemStack::new, recipeitemstack -> recipeitemstack.e);
    private final HolderSet<Item> e;
    @Nullable
    private List<ItemStack> itemStacks;

    public boolean isExact() {
        return this.itemStacks != null;
    }

    public List<ItemStack> itemStacks() {
        return this.itemStacks;
    }

    public static RecipeItemStack ofStacks(List<ItemStack> stacks) {
        RecipeItemStack recipe = RecipeItemStack.a(stacks.stream().map(ItemStack::h));
        recipe.itemStacks = stacks;
        return recipe;
    }

    private RecipeItemStack(HolderSet<Item> holderset) {
        holderset.d().ifRight(list -> {
            if (list.isEmpty()) {
                throw new UnsupportedOperationException("Ingredients can't be empty");
            }
            if (list.contains(Items.a.e())) {
                throw new UnsupportedOperationException("Ingredient can't contain air");
            }
        });
        this.e = holderset;
    }

    public static boolean a(Optional<RecipeItemStack> optional, ItemStack itemstack) {
        Optional<Boolean> optional1 = optional.map(recipeitemstack -> recipeitemstack.a(itemstack));
        Objects.requireNonNull(itemstack);
        return (Boolean)optional1.orElseGet(itemstack::f);
    }

    @Deprecated
    public Stream<Holder<Item>> a() {
        return this.e.a();
    }

    public boolean b() {
        return this.e.b() == 0;
    }

    public boolean a(ItemStack itemstack) {
        if (this.isExact()) {
            for (ItemStack itemstack1 : this.itemStacks()) {
                if (itemstack1.h() != itemstack.h() || !ItemStack.c(itemstack, itemstack1)) continue;
                return true;
            }
            return false;
        }
        return itemstack.a(this.e);
    }

    public boolean a(Holder<Item> holder) {
        return this.e.a(holder);
    }

    public boolean equals(Object object) {
        if (object instanceof RecipeItemStack) {
            RecipeItemStack recipeitemstack = (RecipeItemStack)object;
            return Objects.equals(this.e, recipeitemstack.e) && Objects.equals(this.itemStacks, recipeitemstack.itemStacks);
        }
        return false;
    }

    public static RecipeItemStack a(IMaterial imaterial) {
        return new RecipeItemStack(HolderSet.a(imaterial.h().e()));
    }

    public static RecipeItemStack a(IMaterial ... aimaterial) {
        return RecipeItemStack.a(Arrays.stream(aimaterial));
    }

    public static RecipeItemStack a(Stream<? extends IMaterial> stream) {
        return new RecipeItemStack(HolderSet.a(stream.map(imaterial -> imaterial.h().e()).toList()));
    }

    public static RecipeItemStack a(HolderSet<Item> holderset) {
        return new RecipeItemStack(holderset);
    }

    public SlotDisplay c() {
        return (SlotDisplay)this.e.d().map(SlotDisplay.h::new, list -> new SlotDisplay.b(list.stream().map(RecipeItemStack::b).toList()));
    }

    public static SlotDisplay a(Optional<RecipeItemStack> optional) {
        return optional.map(RecipeItemStack::c).orElse(SlotDisplay.c.c);
    }

    private static SlotDisplay b(Holder<Item> holder) {
        SlotDisplay.d slotdisplay = new SlotDisplay.d(holder);
        ItemStack itemstack = holder.a().i();
        if (!itemstack.f()) {
            SlotDisplay.f slotdisplay1 = new SlotDisplay.f(itemstack);
            return new SlotDisplay.j(slotdisplay, slotdisplay1);
        }
        return slotdisplay;
    }
}

