/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAttachable;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyAttachPosition;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;

public class BlockLever
extends BlockAttachable {
    public static final MapCodec<BlockLever> a = BlockLever.b(BlockLever::new);
    public static final BlockStateBoolean b = BlockProperties.A;
    private final Function<IBlockData, VoxelShape> d;

    public MapCodec<BlockLever> a() {
        return a;
    }

    protected BlockLever(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.l((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.C.b()).b(f, EnumDirection.c)).b(b, false)).b(c, BlockPropertyAttachPosition.b));
        this.d = this.b();
    }

    private Function<IBlockData, VoxelShape> b() {
        Map<BlockPropertyAttachPosition, Map<EnumDirection, VoxelShape>> map = VoxelShapes.e(Block.b(6.0, 8.0, 10.0, 16.0));
        return this.a((IBlockData iblockdata) -> (VoxelShape)((Map)map.get(iblockdata.c(c))).get(iblockdata.c(f)), b);
    }

    @Override
    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return this.d.apply(iblockdata);
    }

    @Override
    protected EnumInteractionResult a(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, MovingObjectPositionBlock movingobjectpositionblock) {
        if (world.D_()) {
            IBlockData iblockdata1 = (IBlockData)iblockdata.a(b);
            if (iblockdata1.c(b).booleanValue()) {
                BlockLever.a(iblockdata1, (GeneratorAccess)world, blockposition, 1.0f);
            }
        } else {
            boolean powered = iblockdata.c(b);
            org.bukkit.block.Block block = world.getWorld().getBlockAt(blockposition.u(), blockposition.v(), blockposition.w());
            int old = powered ? 15 : 0;
            int current = !powered ? 15 : 0;
            BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(block, old, current);
            world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
            if (eventRedstone.getNewCurrent() > 0 != !powered) {
                return EnumInteractionResult.a;
            }
            this.b(iblockdata, world, blockposition, (EntityHuman)null);
        }
        return EnumInteractionResult.a;
    }

    @Override
    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, Explosion explosion, BiConsumer<ItemStack, BlockPosition> biconsumer) {
        if (explosion.g()) {
            this.b(iblockdata, (World)worldserver, blockposition, (EntityHuman)null);
        }
        super.a(iblockdata, worldserver, blockposition, explosion, biconsumer);
    }

    public void b(IBlockData iblockdata, World world, BlockPosition blockposition, @Nullable EntityHuman entityhuman) {
        iblockdata = (IBlockData)iblockdata.a(b);
        world.a(blockposition, iblockdata, 3);
        this.c(iblockdata, world, blockposition);
        BlockLever.a(entityhuman, (GeneratorAccess)world, blockposition, iblockdata);
        world.a((Entity)entityhuman, iblockdata.c(b) != false ? GameEvent.a : GameEvent.e, blockposition);
    }

    protected static void a(@Nullable EntityHuman entityhuman, GeneratorAccess generatoraccess, BlockPosition blockposition, IBlockData iblockdata) {
        float f2 = iblockdata.c(b) != false ? 0.6f : 0.5f;
        generatoraccess.a((Entity)entityhuman, blockposition, SoundEffects.pI, SoundCategory.e, 0.3f, f2);
    }

    private static void a(IBlockData iblockdata, GeneratorAccess generatoraccess, BlockPosition blockposition, float f2) {
        EnumDirection enumdirection = ((EnumDirection)iblockdata.c(f)).g();
        EnumDirection enumdirection1 = BlockLever.p(iblockdata).g();
        double d0 = (double)blockposition.u() + 0.5 + 0.1 * (double)enumdirection.j() + 0.2 * (double)enumdirection1.j();
        double d1 = (double)blockposition.v() + 0.5 + 0.1 * (double)enumdirection.k() + 0.2 * (double)enumdirection1.k();
        double d2 = (double)blockposition.w() + 0.5 + 0.1 * (double)enumdirection.l() + 0.2 * (double)enumdirection1.l();
        generatoraccess.a(new ParticleParamRedstone(0xFF0000, f2), d0, d1, d2, 0.0, 0.0, 0.0);
    }

    @Override
    public void a(IBlockData iblockdata, World world, BlockPosition blockposition, RandomSource randomsource) {
        if (iblockdata.c(b).booleanValue() && randomsource.i() < 0.25f) {
            BlockLever.a(iblockdata, (GeneratorAccess)world, blockposition, 0.5f);
        }
    }

    @Override
    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, boolean flag) {
        if (!flag && iblockdata.c(b).booleanValue()) {
            this.c(iblockdata, worldserver, blockposition);
        }
    }

    @Override
    protected int a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        return iblockdata.c(b) != false ? 15 : 0;
    }

    @Override
    protected int b(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        return iblockdata.c(b) != false && BlockLever.p(iblockdata) == enumdirection ? 15 : 0;
    }

    @Override
    protected boolean e_(IBlockData iblockdata) {
        return true;
    }

    private void c(IBlockData iblockdata, World world, BlockPosition blockposition) {
        EnumDirection enumdirection;
        Orientation orientation = ExperimentalRedstoneUtils.a(world, enumdirection, (enumdirection = BlockLever.p(iblockdata).g()).o().d() ? EnumDirection.b : (EnumDirection)iblockdata.c(f));
        world.a(blockposition, (Block)this, orientation);
        world.a(blockposition.a(enumdirection), (Block)this, orientation);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(c, f, b);
    }
}

