/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Optionull;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NbtException;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.chunk.PalettedContainerFactory;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ProtoChunkTickList;
import net.minecraft.world.ticks.TickListChunk;
import org.slf4j.Logger;

public final class SerializableChunkData
extends Record {
    private final PalettedContainerFactory h;
    private final ChunkCoordIntPair i;
    private final int j;
    private final long k;
    private final long l;
    private final ChunkStatus m;
    @Nullable
    private final BlendingData.d n;
    @Nullable
    private final BelowZeroRetrogen o;
    private final ChunkConverter p;
    @Nullable
    private final long[] q;
    private final Map<HeightMap.Type, long[]> r;
    private final IChunkAccess.b s;
    private final ShortList[] t;
    private final boolean u;
    private final List<b> v;
    private final List<NBTTagCompound> w;
    private final List<NBTTagCompound> x;
    private final NBTTagCompound y;
    @Nullable
    private final NBTBase persistentDataContainer;
    private static final Codec<List<TickListChunk<Block>>> z = TickListChunk.a(BuiltInRegistries.e.q()).listOf();
    private static final Codec<List<TickListChunk<FluidType>>> A = TickListChunk.a(BuiltInRegistries.c.q()).listOf();
    private static final Logger B = LogUtils.getLogger();
    private static final String C = "UpgradeData";
    private static final String D = "block_ticks";
    private static final String E = "fluid_ticks";
    public static final String a = "xPos";
    public static final String b = "zPos";
    public static final String c = "Heightmaps";
    public static final String d = "isLightOn";
    public static final String e = "sections";
    public static final String f = "BlockLight";
    public static final String g = "SkyLight";

    public SerializableChunkData(PalettedContainerFactory containerFactory, ChunkCoordIntPair chunkPos, int minSectionY, long lastUpdateTime, long inhabitedTime, ChunkStatus chunkStatus, @Nullable BlendingData.d blendingData, @Nullable BelowZeroRetrogen belowZeroRetrogen, ChunkConverter upgradeData, @Nullable long[] carvingMask, Map<HeightMap.Type, long[]> heightmaps, IChunkAccess.b packedTicks, ShortList[] postProcessingSections, boolean lightCorrect, List<b> sectionData, List<NBTTagCompound> entities, List<NBTTagCompound> blockEntities, NBTTagCompound structureData, @Nullable NBTBase persistentDataContainer) {
        this.h = containerFactory;
        this.i = chunkPos;
        this.j = minSectionY;
        this.k = lastUpdateTime;
        this.l = inhabitedTime;
        this.m = chunkStatus;
        this.n = blendingData;
        this.o = belowZeroRetrogen;
        this.p = upgradeData;
        this.q = carvingMask;
        this.r = heightmaps;
        this.s = packedTicks;
        this.t = postProcessingSections;
        this.u = lightCorrect;
        this.v = sectionData;
        this.w = entities;
        this.x = blockEntities;
        this.y = structureData;
        this.persistentDataContainer = persistentDataContainer;
    }

    @Nullable
    public static SerializableChunkData a(LevelHeightAccessor levelheightaccessor, PalettedContainerFactory palettedcontainerfactory, NBTTagCompound nbttagcompound) {
        if (nbttagcompound.i("Status").isEmpty()) {
            return null;
        }
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(nbttagcompound.b(a, 0), nbttagcompound.b(b, 0));
        long i2 = nbttagcompound.b("LastUpdate", 0L);
        long j2 = nbttagcompound.b("InhabitedTime", 0L);
        ChunkStatus chunkstatus = nbttagcompound.a("Status", ChunkStatus.o).orElse(ChunkStatus.c);
        ChunkConverter chunkconverter = nbttagcompound.m(C).map(nbttagcompound1 -> new ChunkConverter((NBTTagCompound)nbttagcompound1, levelheightaccessor)).orElse(ChunkConverter.a);
        boolean flag = nbttagcompound.b(d, false);
        BlendingData.d blendingdata_d = nbttagcompound.a("blending_data", BlendingData.d.a).orElse(null);
        BelowZeroRetrogen belowzeroretrogen = nbttagcompound.a("below_zero_retrogen", BelowZeroRetrogen.a).orElse(null);
        long[] along = nbttagcompound.l("carving_mask").orElse(null);
        EnumMap<HeightMap.Type, long[]> map = new EnumMap<HeightMap.Type, long[]>(HeightMap.Type.class);
        nbttagcompound.m(c).ifPresent(nbttagcompound1 -> {
            for (HeightMap.Type heightmap_type : chunkstatus.e()) {
                nbttagcompound1.l(heightmap_type.a()).ifPresent(along1 -> map.put(heightmap_type, (long[])along1));
            }
        });
        List<TickListChunk<Block>> list = TickListChunk.a(nbttagcompound.a(D, z).orElse(List.of()), chunkcoordintpair);
        List<TickListChunk<FluidType>> list1 = TickListChunk.a(nbttagcompound.a(E, A).orElse(List.of()), chunkcoordintpair);
        IChunkAccess.b ichunkaccess_b = new IChunkAccess.b(list, list1);
        NBTTagList nbttaglist = nbttagcompound.p("PostProcessing");
        ShortList[] ashortlist = new ShortList[nbttaglist.size()];
        for (int k2 = 0; k2 < nbttaglist.size(); ++k2) {
            NBTTagList nbttaglist1 = nbttaglist.f(k2);
            ShortArrayList shortlist = new ShortArrayList(nbttaglist1.size());
            for (int l2 = 0; l2 < nbttaglist1.size(); ++l2) {
                shortlist.add(nbttaglist1.a(l2, (short)0));
            }
            ashortlist[k2] = shortlist;
        }
        List<NBTTagCompound> list2 = nbttagcompound.o("entities").stream().flatMap(NBTTagList::j).toList();
        List<NBTTagCompound> list3 = nbttagcompound.o("block_entities").stream().flatMap(NBTTagList::j).toList();
        NBTTagCompound nbttagcompound12 = nbttagcompound.n("structures");
        NBTTagList nbttaglist2 = nbttagcompound.p(e);
        ArrayList<b> list4 = new ArrayList<b>(nbttaglist2.size());
        Codec<DataPaletteBlock<Holder<BiomeBase>>> codec = palettedcontainerfactory.biomeContainerCodecRW();
        Codec<DataPaletteBlock<IBlockData>> codec1 = palettedcontainerfactory.e();
        for (int i1 = 0; i1 < nbttaglist2.size(); ++i1) {
            ChunkSection chunksection;
            Optional<NBTTagCompound> optional = nbttaglist2.a(i1);
            if (optional.isEmpty()) continue;
            NBTTagCompound nbttagcompound2 = optional.get();
            byte j1 = nbttagcompound2.b("Y", (byte)0);
            if (j1 >= levelheightaccessor.at() && j1 <= levelheightaccessor.au()) {
                Optional<PalettedContainerRO<Object>> optional1 = nbttagcompound2.m("block_states").map(nbttagcompound3 -> (DataPaletteBlock)codec1.parse((DynamicOps)DynamicOpsNBT.a, nbttagcompound3).promotePartial(s2 -> SerializableChunkData.a(chunkcoordintpair, j1, s2)).getOrThrow(a::new));
                Objects.requireNonNull(palettedcontainerfactory);
                DataPaletteBlock datapaletteblock = (DataPaletteBlock)optional1.orElseGet(palettedcontainerfactory::a);
                optional1 = nbttagcompound2.m("biomes").map(nbttagcompound3 -> (PalettedContainerRO)codec.parse((DynamicOps)DynamicOpsNBT.a, nbttagcompound3).promotePartial(s2 -> SerializableChunkData.a(chunkcoordintpair, j1, s2)).getOrThrow(a::new));
                Objects.requireNonNull(palettedcontainerfactory);
                DataPaletteBlock palettedcontainerro = (DataPaletteBlock)optional1.orElseGet(palettedcontainerfactory::b);
                chunksection = new ChunkSection(datapaletteblock, palettedcontainerro);
            } else {
                chunksection = null;
            }
            NibbleArray nibblearray = nbttagcompound2.j(f).map(NibbleArray::new).orElse(null);
            NibbleArray nibblearray1 = nbttagcompound2.j(g).map(NibbleArray::new).orElse(null);
            list4.add(new b(j1, chunksection, nibblearray, nibblearray1));
        }
        return new SerializableChunkData(palettedcontainerfactory, chunkcoordintpair, levelheightaccessor.at(), i2, j2, chunkstatus, blendingdata_d, belowzeroretrogen, chunkconverter, along, map, ichunkaccess_b, ashortlist, flag, list4, list2, list3, nbttagcompound12, nbttagcompound.a("ChunkBukkitValues"));
    }

    public ProtoChunk a(WorldServer worldserver, VillagePlace villageplace, RegionStorageInfo regionstorageinfo, ChunkCoordIntPair chunkcoordintpair) {
        IChunkAccess ichunkaccess;
        if (!Objects.equals(chunkcoordintpair, this.i)) {
            B.error("Chunk file at {} is in the wrong location; relocating. (Expected {}, got {})", new Object[]{chunkcoordintpair, chunkcoordintpair, this.i});
            worldserver.q().a(this.i, chunkcoordintpair, regionstorageinfo);
        }
        int i2 = worldserver.as();
        ChunkSection[] achunksection = new ChunkSection[i2];
        boolean flag = worldserver.H_().g();
        ChunkProviderServer ichunkprovider = worldserver.n();
        LevelLightEngine levellightengine = ((IChunkProvider)ichunkprovider).r();
        PalettedContainerFactory palettedcontainerfactory = worldserver.ao();
        boolean flag1 = false;
        for (b serializablechunkdata_b : this.v) {
            boolean flag3;
            SectionPosition sectionposition = SectionPosition.a(chunkcoordintpair, serializablechunkdata_b.a);
            if (serializablechunkdata_b.b != null) {
                achunksection[worldserver.g((int)serializablechunkdata_b.a)] = serializablechunkdata_b.b;
                villageplace.a(sectionposition, serializablechunkdata_b.b);
            }
            boolean flag2 = serializablechunkdata_b.c != null;
            boolean bl = flag3 = flag && serializablechunkdata_b.d != null;
            if (!flag2 && !flag3) continue;
            if (!flag1) {
                levellightengine.b(chunkcoordintpair, true);
                flag1 = true;
            }
            if (flag2) {
                levellightengine.a(EnumSkyBlock.b, sectionposition, serializablechunkdata_b.c);
            }
            if (!flag3) continue;
            levellightengine.a(EnumSkyBlock.a, sectionposition, serializablechunkdata_b.d);
        }
        ChunkType chunktype = this.m.d();
        if (chunktype == ChunkType.b) {
            LevelChunkTicks<Block> levelchunkticks = new LevelChunkTicks<Block>(this.s.a());
            LevelChunkTicks<FluidType> levelchunkticks1 = new LevelChunkTicks<FluidType>(this.s.b());
            ichunkaccess = new Chunk(worldserver.a(), chunkcoordintpair, this.p, levelchunkticks, levelchunkticks1, this.l, achunksection, SerializableChunkData.a(worldserver, this.w, this.x), BlendingData.a(this.n));
        } else {
            ProtoChunkTickList<Block> protochunkticklist = ProtoChunkTickList.a(this.s.a());
            ProtoChunkTickList<FluidType> protochunkticklist1 = ProtoChunkTickList.a(this.s.b());
            ProtoChunk protochunk = new ProtoChunk(chunkcoordintpair, this.p, achunksection, protochunkticklist, protochunkticklist1, worldserver, palettedcontainerfactory, BlendingData.a(this.n));
            ichunkaccess = protochunk;
            protochunk.c(this.l);
            if (this.o != null) {
                protochunk.a(this.o);
            }
            protochunk.a(this.m);
            if (this.m.a(ChunkStatus.k)) {
                protochunk.a(levellightengine);
            }
        }
        if (this.persistentDataContainer instanceof NBTTagCompound) {
            ichunkaccess.persistentDataContainer.putAll((NBTTagCompound)this.persistentDataContainer);
        }
        ichunkaccess.a(this.u);
        EnumSet<HeightMap.Type> enumset = EnumSet.noneOf(HeightMap.Type.class);
        for (HeightMap.Type heightmap_type : ichunkaccess.n().e()) {
            long[] along = this.r.get(heightmap_type);
            if (along != null) {
                ichunkaccess.a(heightmap_type, along);
                continue;
            }
            enumset.add(heightmap_type);
        }
        HeightMap.a(ichunkaccess, enumset);
        ichunkaccess.a(SerializableChunkData.a(StructurePieceSerializationContext.a(worldserver), this.y, worldserver.H()));
        ichunkaccess.b(SerializableChunkData.a(worldserver.L_(), chunkcoordintpair, this.y));
        for (int j2 = 0; j2 < this.t.length; ++j2) {
            ichunkaccess.a(this.t[j2], j2);
        }
        if (chunktype == ChunkType.b) {
            return new ProtoChunkExtension((Chunk)ichunkaccess, false);
        }
        ProtoChunk protochunk1 = (ProtoChunk)ichunkaccess;
        for (NBTTagCompound nbttagcompound : this.w) {
            protochunk1.b(nbttagcompound);
        }
        for (NBTTagCompound nbttagcompound1 : this.x) {
            protochunk1.a(nbttagcompound1);
        }
        if (this.q != null) {
            protochunk1.a(new CarvingMask(this.q, ichunkaccess.M_()));
        }
        return protochunk1;
    }

    private static void a(ChunkCoordIntPair chunkcoordintpair, int i2, String s2) {
        B.error("Recoverable errors when loading section [{}, {}, {}]: {}", new Object[]{chunkcoordintpair.h, i2, chunkcoordintpair.i, s2});
    }

    public static SerializableChunkData a(WorldServer worldserver, IChunkAccess ichunkaccess) {
        if (!ichunkaccess.s()) {
            throw new IllegalArgumentException("Chunk can't be serialized: " + String.valueOf(ichunkaccess));
        }
        ChunkCoordIntPair chunkcoordintpair = ichunkaccess.f();
        ArrayList<b> list = new ArrayList<b>();
        ChunkSection[] achunksection = ichunkaccess.d();
        LightEngineThreaded levellightengine = worldserver.n().a();
        for (int i2 = levellightengine.d(); i2 < levellightengine.e(); ++i2) {
            NibbleArray nibblearray3;
            int j2 = ichunkaccess.g(i2);
            boolean flag = j2 >= 0 && j2 < achunksection.length;
            NibbleArray nibblearray = levellightengine.a(EnumSkyBlock.b).a(SectionPosition.a(chunkcoordintpair, i2));
            NibbleArray nibblearray1 = levellightengine.a(EnumSkyBlock.a).a(SectionPosition.a(chunkcoordintpair, i2));
            NibbleArray nibbleArray = nibblearray != null && !nibblearray.d() ? nibblearray.b() : null;
            NibbleArray nibbleArray2 = nibblearray3 = nibblearray1 != null && !nibblearray1.d() ? nibblearray1.b() : null;
            if (!flag && nibbleArray == null && nibblearray3 == null) continue;
            ChunkSection chunksection = flag ? achunksection[j2].k() : null;
            list.add(new b(i2, chunksection, nibbleArray, nibblearray3));
        }
        ArrayList<NBTTagCompound> list1 = new ArrayList<NBTTagCompound>(ichunkaccess.c().size());
        for (BlockPosition blockposition : ichunkaccess.c()) {
            NBTTagCompound nbttagcompound = ichunkaccess.a(blockposition, worldserver.L_());
            if (nbttagcompound == null) continue;
            list1.add(nbttagcompound);
        }
        ArrayList<NBTTagCompound> list2 = new ArrayList<NBTTagCompound>();
        long[] along = null;
        if (ichunkaccess.n().d() == ChunkType.a) {
            ProtoChunk protochunk = (ProtoChunk)ichunkaccess;
            list2.addAll(protochunk.J());
            CarvingMask carvingmask = protochunk.F();
            if (carvingmask != null) {
                along = carvingmask.a();
            }
        }
        EnumMap<HeightMap.Type, long[]> map = new EnumMap<HeightMap.Type, long[]>(HeightMap.Type.class);
        for (Map.Entry entry : ichunkaccess.e()) {
            if (!ichunkaccess.n().e().contains(entry.getKey())) continue;
            long[] along1 = ((HeightMap)entry.getValue()).a();
            map.put((HeightMap.Type)entry.getKey(), (long[])along1.clone());
        }
        IChunkAccess.b ichunkaccess_b = ichunkaccess.a(worldserver.ag());
        ShortList[] shortListArray = (ShortList[])Arrays.stream(ichunkaccess.p()).map(shortlist -> shortlist != null ? new ShortArrayList(shortlist) : null).toArray(ShortList[]::new);
        NBTTagCompound nbttagcompound1 = SerializableChunkData.a(StructurePieceSerializationContext.a(worldserver), chunkcoordintpair, ichunkaccess.g(), ichunkaccess.h());
        NBTTagCompound persistentDataContainer = null;
        if (!ichunkaccess.persistentDataContainer.isEmpty()) {
            persistentDataContainer = ichunkaccess.persistentDataContainer.toTagCompound();
        }
        return new SerializableChunkData(worldserver.ao(), chunkcoordintpair, ichunkaccess.at(), worldserver.ag(), ichunkaccess.w(), ichunkaccess.n(), Optionull.a(ichunkaccess.v(), BlendingData::a), ichunkaccess.z(), ichunkaccess.t().c(), along, map, ichunkaccess_b, shortListArray, ichunkaccess.x(), list, list2, list1, nbttagcompound1, persistentDataContainer);
    }

    public NBTTagCompound a() {
        NBTTagCompound nbttagcompound = GameProfileSerializer.e(new NBTTagCompound());
        nbttagcompound.a(a, this.i.h);
        nbttagcompound.a("yPos", this.j);
        nbttagcompound.a(b, this.i.i);
        nbttagcompound.a("LastUpdate", this.k);
        nbttagcompound.a("InhabitedTime", this.l);
        nbttagcompound.a("Status", BuiltInRegistries.m.b(this.m).toString());
        nbttagcompound.b("blending_data", BlendingData.d.a, this.n);
        nbttagcompound.b("below_zero_retrogen", BelowZeroRetrogen.a, this.o);
        if (!this.p.a()) {
            nbttagcompound.a(C, this.p.b());
        }
        NBTTagList nbttaglist = new NBTTagList();
        Codec<DataPaletteBlock<IBlockData>> codec = this.h.e();
        Codec<PalettedContainerRO<Holder<BiomeBase>>> codec1 = this.h.h();
        for (b serializablechunkdata_b : this.v) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            ChunkSection chunksection = serializablechunkdata_b.b;
            if (chunksection != null) {
                nbttagcompound1.a("block_states", codec, chunksection.h());
                nbttagcompound1.a("biomes", codec1, chunksection.i());
            }
            if (serializablechunkdata_b.c != null) {
                nbttagcompound1.a(f, serializablechunkdata_b.c.a());
            }
            if (serializablechunkdata_b.d != null) {
                nbttagcompound1.a(g, serializablechunkdata_b.d.a());
            }
            if (nbttagcompound1.j()) continue;
            nbttagcompound1.a("Y", (byte)serializablechunkdata_b.a);
            nbttaglist.add(nbttagcompound1);
        }
        nbttagcompound.a(e, nbttaglist);
        if (this.u) {
            nbttagcompound.a(d, true);
        }
        NBTTagList nbttaglist1 = new NBTTagList();
        nbttaglist1.addAll(this.x);
        nbttagcompound.a("block_entities", nbttaglist1);
        if (this.m.d() == ChunkType.a) {
            NBTTagList nbttaglist2 = new NBTTagList();
            nbttaglist2.addAll(this.w);
            nbttagcompound.a("entities", nbttaglist2);
            if (this.q != null) {
                nbttagcompound.a("carving_mask", this.q);
            }
        }
        SerializableChunkData.a(nbttagcompound, this.s);
        nbttagcompound.a("PostProcessing", SerializableChunkData.a(this.t));
        NBTTagCompound nbttagcompound2 = new NBTTagCompound();
        this.r.forEach((heightmap_type, along) -> nbttagcompound2.a(heightmap_type.a(), new NBTTagLongArray((long[])along)));
        nbttagcompound.a(c, nbttagcompound2);
        nbttagcompound.a("structures", this.y);
        if (this.persistentDataContainer != null) {
            nbttagcompound.a("ChunkBukkitValues", this.persistentDataContainer);
        }
        return nbttagcompound;
    }

    private static void a(NBTTagCompound nbttagcompound, IChunkAccess.b ichunkaccess_b) {
        nbttagcompound.a(D, z, ichunkaccess_b.a());
        nbttagcompound.a(E, A, ichunkaccess_b.b());
    }

    public static ChunkStatus a(@Nullable NBTTagCompound nbttagcompound) {
        return nbttagcompound != null ? nbttagcompound.a("Status", ChunkStatus.o).orElse(ChunkStatus.c) : ChunkStatus.c;
    }

    @Nullable
    private static Chunk.c a(WorldServer worldserver, List<NBTTagCompound> list, List<NBTTagCompound> list1) {
        return list.isEmpty() && list1.isEmpty() ? null : chunk -> {
            worldserver.timings.syncChunkLoadEntitiesTimer.startTiming();
            if (!list.isEmpty()) {
                try (ProblemReporter.j problemreporter_j = new ProblemReporter.j(chunk.E(), B);){
                    worldserver.a(EntityTypes.a(TagValueInput.a((ProblemReporter)problemreporter_j, (HolderLookup.a)worldserver.L_(), list), (World)worldserver, EntitySpawnReason.r));
                }
            }
            worldserver.timings.syncChunkLoadEntitiesTimer.stopTiming();
            worldserver.timings.syncChunkLoadTileEntitiesTimer.startTiming();
            for (NBTTagCompound nbttagcompound : list1) {
                boolean flag = nbttagcompound.b("keepPacked", false);
                if (flag) {
                    chunk.a(nbttagcompound);
                    continue;
                }
                BlockPosition blockposition = TileEntity.a(chunk.f(), nbttagcompound);
                TileEntity tileentity = TileEntity.a(blockposition, chunk.a_(blockposition), nbttagcompound, worldserver.L_());
                if (tileentity == null) continue;
                chunk.a(tileentity);
            }
            worldserver.timings.syncChunkLoadTileEntitiesTimer.stopTiming();
        };
    }

    private static NBTTagCompound a(StructurePieceSerializationContext structurepieceserializationcontext, ChunkCoordIntPair chunkcoordintpair, Map<Structure, StructureStart> map, Map<Structure, LongSet> map1) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        IRegistry<Structure> iregistry = structurepieceserializationcontext.b().f(Registries.bm);
        for (Map.Entry<Structure, StructureStart> map_entry : map.entrySet()) {
            MinecraftKey minecraftkey = iregistry.b(map_entry.getKey());
            nbttagcompound1.a(minecraftkey.toString(), map_entry.getValue().a(structurepieceserializationcontext, chunkcoordintpair));
        }
        nbttagcompound.a("starts", nbttagcompound1);
        NBTTagCompound nbttagcompound2 = new NBTTagCompound();
        for (Map.Entry<Structure, LongSet> map_entry1 : map1.entrySet()) {
            if (map_entry1.getValue().isEmpty()) continue;
            MinecraftKey minecraftkey1 = iregistry.b(map_entry1.getKey());
            nbttagcompound2.a(minecraftkey1.toString(), map_entry1.getValue().toLongArray());
        }
        nbttagcompound.a("References", nbttagcompound2);
        return nbttagcompound;
    }

    private static Map<Structure, StructureStart> a(StructurePieceSerializationContext structurepieceserializationcontext, NBTTagCompound nbttagcompound, long i2) {
        HashMap map = Maps.newHashMap();
        IRegistry<Structure> iregistry = structurepieceserializationcontext.b().f(Registries.bm);
        NBTTagCompound nbttagcompound1 = nbttagcompound.n("starts");
        for (String s2 : nbttagcompound1.e()) {
            MinecraftKey minecraftkey = MinecraftKey.c(s2);
            Structure structure = iregistry.a(minecraftkey);
            if (structure == null) {
                B.error("Unknown structure start: {}", (Object)minecraftkey);
                continue;
            }
            StructureStart structurestart = StructureStart.a(structurepieceserializationcontext, nbttagcompound1.n(s2), i2);
            if (structurestart == null) continue;
            NBTBase persistentBase = nbttagcompound1.n(s2).a("StructureBukkitValues");
            if (persistentBase instanceof NBTTagCompound) {
                structurestart.persistentDataContainer.putAll((NBTTagCompound)persistentBase);
            }
            map.put(structure, structurestart);
        }
        return map;
    }

    private static Map<Structure, LongSet> a(IRegistryCustom iregistrycustom, ChunkCoordIntPair chunkcoordintpair, NBTTagCompound nbttagcompound) {
        HashMap map = Maps.newHashMap();
        IRegistry<Structure> iregistry = iregistrycustom.f(Registries.bm);
        NBTTagCompound nbttagcompound1 = nbttagcompound.n("References");
        nbttagcompound1.a((s2, nbtbase) -> {
            MinecraftKey minecraftkey = MinecraftKey.c(s2);
            Structure structure = (Structure)iregistry.a(minecraftkey);
            if (structure == null) {
                B.warn("Found reference to unknown structure '{}' in chunk {}, discarding", (Object)minecraftkey, (Object)chunkcoordintpair);
            } else {
                Optional<long[]> optional = nbtbase.t_();
                if (!optional.isEmpty()) {
                    map.put(structure, new LongOpenHashSet(Arrays.stream(optional.get()).filter(i2 -> {
                        ChunkCoordIntPair chunkcoordintpair1 = new ChunkCoordIntPair(i2);
                        if (chunkcoordintpair1.a(chunkcoordintpair) > 8) {
                            B.warn("Found invalid structure reference [ {} @ {} ] for chunk {}.", new Object[]{minecraftkey, chunkcoordintpair1, chunkcoordintpair});
                            return false;
                        }
                        return true;
                    }).toArray()));
                }
            }
        });
        return map;
    }

    private static NBTTagList a(ShortList[] ashortlist) {
        NBTTagList nbttaglist = new NBTTagList();
        for (ShortList shortlist : ashortlist) {
            NBTTagList nbttaglist1 = new NBTTagList();
            if (shortlist != null) {
                for (int i2 = 0; i2 < shortlist.size(); ++i2) {
                    nbttaglist1.add(NBTTagShort.a(shortlist.getShort(i2)));
                }
            }
            nbttaglist.add(nbttaglist1);
        }
        return nbttaglist;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SerializableChunkData.class, "containerFactory;chunkPos;minSectionY;lastUpdateTime;inhabitedTime;chunkStatus;blendingData;belowZeroRetrogen;upgradeData;carvingMask;heightmaps;packedTicks;postProcessingSections;lightCorrect;sectionData;entities;blockEntities;structureData;persistentDataContainer", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "persistentDataContainer"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SerializableChunkData.class, "containerFactory;chunkPos;minSectionY;lastUpdateTime;inhabitedTime;chunkStatus;blendingData;belowZeroRetrogen;upgradeData;carvingMask;heightmaps;packedTicks;postProcessingSections;lightCorrect;sectionData;entities;blockEntities;structureData;persistentDataContainer", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "persistentDataContainer"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SerializableChunkData.class, "containerFactory;chunkPos;minSectionY;lastUpdateTime;inhabitedTime;chunkStatus;blendingData;belowZeroRetrogen;upgradeData;carvingMask;heightmaps;packedTicks;postProcessingSections;lightCorrect;sectionData;entities;blockEntities;structureData;persistentDataContainer", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "persistentDataContainer"}, this, o2);
    }

    public PalettedContainerFactory b() {
        return this.h;
    }

    public ChunkCoordIntPair c() {
        return this.i;
    }

    public int d() {
        return this.j;
    }

    public long e() {
        return this.k;
    }

    public long f() {
        return this.l;
    }

    public ChunkStatus g() {
        return this.m;
    }

    @Nullable
    public BlendingData.d h() {
        return this.n;
    }

    @Nullable
    public BelowZeroRetrogen i() {
        return this.o;
    }

    public ChunkConverter j() {
        return this.p;
    }

    @Nullable
    public long[] k() {
        return this.q;
    }

    public Map<HeightMap.Type, long[]> l() {
        return this.r;
    }

    public IChunkAccess.b m() {
        return this.s;
    }

    public ShortList[] n() {
        return this.t;
    }

    public boolean o() {
        return this.u;
    }

    public List<b> p() {
        return this.v;
    }

    public List<NBTTagCompound> q() {
        return this.w;
    }

    public List<NBTTagCompound> r() {
        return this.x;
    }

    public NBTTagCompound s() {
        return this.y;
    }

    @Nullable
    public NBTBase persistentDataContainer() {
        return this.persistentDataContainer;
    }

    public record b(int a, @Nullable ChunkSection b, @Nullable NibbleArray c, @Nullable NibbleArray d) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "y;chunkSection;blockLight;skyLight", "a", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "y;chunkSection;blockLight;skyLight", "a", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "y;chunkSection;blockLight;skyLight", "a", "b", "c", "d"}, this, o2);
        }
    }

    public static class a
    extends NbtException {
        public a(String s2) {
            super(s2);
        }
    }
}

