/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.FileUtils;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NbtFormatException;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.nbt.visitors.SkipFields;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.util.MemoryReserve;
import net.minecraft.util.SessionLock;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.storage.FileNameDateFormatter;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldInfo;
import net.minecraft.world.level.storage.WorldNBTStorage;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;
import net.minecraft.world.level.validation.PathAllowList;
import org.slf4j.Logger;

public class Convertable {
    static final Logger c = LogUtils.getLogger();
    static final DateTimeFormatter d = FileNameDateFormatter.a();
    public static final String a = "Data";
    private static final PathMatcher e = path -> false;
    public static final String b = "allowed_symlinks.txt";
    private static final int f = 0x6400000;
    private static final int g = 0x4000000;
    public final Path h;
    private final Path i;
    final DataFixer j;
    private final DirectoryValidator k;

    public Convertable(Path path, Path path1, DirectoryValidator directoryvalidator, DataFixer datafixer) {
        this.j = datafixer;
        try {
            FileUtils.c(path);
        }
        catch (IOException ioexception) {
            throw new UncheckedIOException(ioexception);
        }
        this.h = path;
        this.i = path1;
        this.k = directoryvalidator;
    }

    public static DirectoryValidator a(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            DirectoryValidator directoryValidator;
            block9: {
                BufferedReader bufferedreader = Files.newBufferedReader(path);
                try {
                    directoryValidator = new DirectoryValidator(PathAllowList.a(bufferedreader));
                    if (bufferedreader == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (bufferedreader != null) {
                            try {
                                bufferedreader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        c.error("Failed to parse {}, disallowing all symbolic links", (Object)b, (Object)exception);
                    }
                }
                bufferedreader.close();
            }
            return directoryValidator;
        }
        return new DirectoryValidator(e);
    }

    public static Convertable b(Path path) {
        DirectoryValidator directoryvalidator = Convertable.a(path.resolve(b));
        return new Convertable(path, path.resolve("../backups"), directoryvalidator, DataConverterRegistry.a());
    }

    public static WorldDataConfiguration a(Dynamic<?> dynamic) {
        DataResult dataresult = WorldDataConfiguration.c.parse(dynamic);
        Logger logger = c;
        Objects.requireNonNull(logger);
        return dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).orElse(WorldDataConfiguration.d);
    }

    public static WorldLoader.d a(Dynamic<?> dynamic, ResourcePackRepository resourcepackrepository, boolean flag) {
        return new WorldLoader.d(resourcepackrepository, Convertable.a(dynamic), flag, false);
    }

    public static LevelDataAndDimensions a(Dynamic<?> dynamic, WorldDataConfiguration worlddataconfiguration, IRegistry<WorldDimension> iregistry, HolderLookup.a holderlookup_a) {
        Dynamic<?> dynamic1 = RegistryOps.a(dynamic, holderlookup_a);
        Dynamic dynamic2 = dynamic1.get("WorldGenSettings").orElseEmptyMap();
        GeneratorSettings generatorsettings = (GeneratorSettings)GeneratorSettings.a.parse(dynamic2).getOrThrow();
        WorldSettings worldsettings = WorldSettings.a(dynamic1, worlddataconfiguration);
        WorldDimensions.b worlddimensions_b = generatorsettings.b().a(iregistry);
        Lifecycle lifecycle = worlddimensions_b.a().add(holderlookup_a.d());
        WorldDataServer worlddataserver = WorldDataServer.a(dynamic1, worldsettings, worlddimensions_b.d(), generatorsettings.a(), lifecycle);
        worlddataserver.pdc = (NBTBase)dynamic1.getElement("BukkitValues", null);
        return new LevelDataAndDimensions(worlddataserver, worlddimensions_b);
    }

    public String a() {
        return "Anvil";
    }

    public a b() throws LevelStorageException {
        a a2;
        block9: {
            if (!Files.isDirectory(this.h, new LinkOption[0])) {
                throw new LevelStorageException(IChatBaseComponent.c("selectWorld.load_folder_access"));
            }
            Stream<Path> stream = Files.list(this.h);
            try {
                List<b> list = stream.filter(path -> Files.isDirectory(path, new LinkOption[0])).map(b::new).filter(convertable_b -> Files.isRegularFile(convertable_b.b(), new LinkOption[0]) || Files.isRegularFile(convertable_b.c(), new LinkOption[0])).toList();
                a2 = new a(list);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioexception) {
                    throw new LevelStorageException(IChatBaseComponent.c("selectWorld.load_folder_access"));
                }
            }
            stream.close();
        }
        return a2;
    }

    public CompletableFuture<List<WorldInfo>> a(a convertable_a) {
        ArrayList<CompletableFuture<WorldInfo>> list = new ArrayList<CompletableFuture<WorldInfo>>(convertable_a.a.size());
        for (b convertable_b : convertable_a.a) {
            list.add(CompletableFuture.supplyAsync(() -> {
                boolean flag;
                try {
                    flag = SessionLock.b(convertable_b.f());
                }
                catch (Exception exception) {
                    c.warn("Failed to read {} lock", (Object)convertable_b.f(), (Object)exception);
                    return null;
                }
                try {
                    return this.a(convertable_b, flag);
                }
                catch (OutOfMemoryError outofmemoryerror) {
                    MemoryReserve.b();
                    String s2 = "Ran out of memory trying to read summary of world folder \"" + convertable_b.a() + "\"";
                    c.error(LogUtils.FATAL_MARKER, s2);
                    OutOfMemoryError outofmemoryerror1 = new OutOfMemoryError("Ran out of memory reading level data");
                    outofmemoryerror1.initCause(outofmemoryerror);
                    CrashReport crashreport = CrashReport.a(outofmemoryerror1, s2);
                    CrashReportSystemDetails crashreportsystemdetails = crashreport.a("World details");
                    crashreportsystemdetails.a("Folder Name", convertable_b.a());
                    try {
                        long i2 = Files.size(convertable_b.b());
                        crashreportsystemdetails.a("level.dat size", i2);
                    }
                    catch (IOException ioexception) {
                        crashreportsystemdetails.a("level.dat size", ioexception);
                    }
                    throw new ReportedException(crashreport);
                }
            }, SystemUtils.h().a("loadLevelSummaries")));
        }
        return SystemUtils.f(list).thenApply(list1 -> list1.stream().filter(Objects::nonNull).sorted().toList());
    }

    private int f() {
        return 19133;
    }

    static NBTTagCompound c(Path path) throws IOException {
        return NBTCompressedStreamTools.a(path, NBTReadLimiter.a(0x6400000L));
    }

    static Dynamic<?> a(Path path, DataFixer datafixer) throws IOException {
        NBTTagCompound nbttagcompound = Convertable.c(path);
        NBTTagCompound nbttagcompound1 = nbttagcompound.n(a);
        int i2 = GameProfileSerializer.b(nbttagcompound1, -1);
        Dynamic dynamic = DataFixTypes.a.a(datafixer, new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)nbttagcompound1), i2);
        dynamic = dynamic.update("Player", dynamic1 -> DataFixTypes.c.a(datafixer, dynamic1, i2));
        dynamic = dynamic.update("WorldGenSettings", dynamic1 -> DataFixTypes.t.a(datafixer, dynamic1, i2));
        return dynamic;
    }

    private WorldInfo a(b convertable_b, boolean flag) {
        Path path = convertable_b.b();
        if (Files.exists(path, new LinkOption[0])) {
            try {
                List<ForbiddenSymlinkInfo> list;
                if (Files.isSymbolicLink(path) && !(list = this.k.a(path)).isEmpty()) {
                    c.warn("{}", (Object)ContentValidationException.a(path, list));
                    return new WorldInfo.c(convertable_b.a(), convertable_b.d());
                }
                NBTBase nbtbase = Convertable.e(path);
                if (nbtbase instanceof NBTTagCompound) {
                    NBTTagCompound nbttagcompound = (NBTTagCompound)nbtbase;
                    NBTTagCompound nbttagcompound1 = nbttagcompound.n(a);
                    int i2 = GameProfileSerializer.b(nbttagcompound1, -1);
                    Dynamic dynamic = DataFixTypes.b.a(this.j, new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)nbttagcompound1), i2);
                    return this.a(dynamic, convertable_b, flag);
                }
                c.warn("Invalid root tag in {}", (Object)path);
            }
            catch (Exception exception) {
                c.error("Exception reading {}", (Object)path, (Object)exception);
            }
        }
        return new WorldInfo.b(convertable_b.a(), convertable_b.d(), Convertable.a(convertable_b));
    }

    private static long a(b convertable_b) {
        Instant instant = Convertable.d(convertable_b.b());
        if (instant == null) {
            instant = Convertable.d(convertable_b.c());
        }
        return instant == null ? -1L : instant.toEpochMilli();
    }

    @Nullable
    static Instant d(Path path) {
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]).toInstant();
        }
        catch (IOException ioexception) {
            return null;
        }
    }

    WorldInfo a(Dynamic<?> dynamic, b convertable_b, boolean flag) {
        LevelVersion levelversion = LevelVersion.a(dynamic);
        int i2 = levelversion.a();
        if (i2 != 19132 && i2 != 19133) {
            throw new NbtFormatException("Unknown data version: " + Integer.toHexString(i2));
        }
        boolean flag1 = i2 != this.f();
        Path path = convertable_b.d();
        WorldDataConfiguration worlddataconfiguration = Convertable.a(dynamic);
        WorldSettings worldsettings = WorldSettings.a(dynamic, worlddataconfiguration);
        FeatureFlagSet featureflagset = Convertable.b(dynamic);
        boolean flag2 = FeatureFlags.a(featureflagset);
        return new WorldInfo(worldsettings, levelversion, convertable_b.a(), flag1, flag, flag2, path);
    }

    private static FeatureFlagSet b(Dynamic<?> dynamic) {
        Set<MinecraftKey> set = dynamic.get("enabled_features").asStream().flatMap(dynamic1 -> dynamic1.asString().result().map(MinecraftKey::c).stream()).collect(Collectors.toSet());
        return FeatureFlags.e.a(set, minecraftkey -> {});
    }

    @Nullable
    private static NBTBase e(Path path) throws IOException {
        SkipFields skipfields = new SkipFields(new FieldSelector(a, NBTTagCompound.b, "Player"), new FieldSelector(a, NBTTagCompound.b, "WorldGenSettings"));
        NBTCompressedStreamTools.a(path, (StreamTagVisitor)skipfields, NBTReadLimiter.a(0x6400000L));
        return skipfields.d();
    }

    public boolean a(String s2) {
        try {
            Path path = this.c(s2);
            Files.createDirectory(path, new FileAttribute[0]);
            Files.deleteIfExists(path);
            return true;
        }
        catch (IOException ioexception) {
            return false;
        }
    }

    public boolean b(String s2) {
        try {
            return Files.isDirectory(this.c(s2), new LinkOption[0]);
        }
        catch (InvalidPathException invalidpathexception) {
            return false;
        }
    }

    public Path c(String s2) {
        return this.h.resolve(s2);
    }

    public Path c() {
        return this.h;
    }

    public Path d() {
        return this.i;
    }

    public ConversionSession validateAndCreateAccess(String s2, ResourceKey<WorldDimension> dimensionType) throws IOException, ContentValidationException {
        Path path = this.c(s2);
        List<ForbiddenSymlinkInfo> list = this.k.a(path, true);
        if (!list.isEmpty()) {
            throw new ContentValidationException(path, list);
        }
        return new ConversionSession(s2, path, dimensionType);
    }

    public ConversionSession createAccess(String s2, ResourceKey<WorldDimension> dimensionType) throws IOException {
        Path path = this.c(s2);
        return new ConversionSession(s2, path, dimensionType);
    }

    public DirectoryValidator e() {
        return this.k;
    }

    public static Path getStorageFolder(Path path, ResourceKey<WorldDimension> dimensionType) {
        if (dimensionType == WorldDimension.b) {
            return path;
        }
        if (dimensionType == WorldDimension.c) {
            return path.resolve("DIM-1");
        }
        if (dimensionType == WorldDimension.d) {
            return path.resolve("DIM1");
        }
        return path.resolve("dimensions").resolve(dimensionType.a().b()).resolve(dimensionType.a().a());
    }

    public record a(List<b> a) implements Iterable<b>
    {
        private final List<b> a;

        public boolean a() {
            return this.a.isEmpty();
        }

        @Override
        public Iterator<b> iterator() {
            return this.a.iterator();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "levels", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "levels", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "levels", "a"}, this, o2);
        }

        public List<b> b() {
            return this.a;
        }
    }

    public record b(Path a) {
        private final Path a;

        public String a() {
            return this.a.getFileName().toString();
        }

        public Path b() {
            return this.a(SavedFile.e);
        }

        public Path c() {
            return this.a(SavedFile.f);
        }

        public Path a(LocalDateTime localdatetime) {
            Path path = this.a;
            String s2 = SavedFile.e.a();
            return path.resolve(s2 + "_corrupted_" + localdatetime.format(d));
        }

        public Path b(LocalDateTime localdatetime) {
            Path path = this.a;
            String s2 = SavedFile.e.a();
            return path.resolve(s2 + "_raw_" + localdatetime.format(d));
        }

        public Path d() {
            return this.a(SavedFile.g);
        }

        public Path e() {
            return this.a(SavedFile.h);
        }

        public Path a(SavedFile savedfile) {
            return this.a.resolve(savedfile.a());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "path", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "path", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "path", "a"}, this, o2);
        }

        public Path f() {
            return this.a;
        }
    }

    public class ConversionSession
    implements AutoCloseable {
        final SessionLock b;
        public final b c;
        private final String d;
        private final Map<SavedFile, Path> e = Maps.newHashMap();
        public final ResourceKey<WorldDimension> dimensionType;

        ConversionSession(String s2, Path path, ResourceKey<WorldDimension> dimensionType) throws IOException {
            this.dimensionType = dimensionType;
            this.d = s2;
            this.c = new b(path);
            this.b = SessionLock.a(path);
        }

        public long a() {
            try {
                return Files.getFileStore(this.c.a).getUsableSpace();
            }
            catch (Exception exception) {
                return Long.MAX_VALUE;
            }
        }

        public boolean b() {
            return this.a() < 0x4000000L;
        }

        public void c() {
            try {
                this.close();
            }
            catch (IOException ioexception) {
                c.warn("Failed to unlock access to level {}", (Object)this.f(), (Object)ioexception);
            }
        }

        public Convertable d() {
            return Convertable.this;
        }

        public b e() {
            return this.c;
        }

        public String f() {
            return this.d;
        }

        public Path a(SavedFile savedfile) {
            Map<SavedFile, Path> map = this.e;
            b convertable_b = this.c;
            Objects.requireNonNull(this.c);
            return map.computeIfAbsent(savedfile, convertable_b::a);
        }

        public Path a(ResourceKey<World> resourcekey) {
            return Convertable.getStorageFolder(this.c.f(), this.dimensionType);
        }

        private void o() {
            if (!this.b.a()) {
                throw new IllegalStateException("Lock is no longer valid");
            }
        }

        public WorldNBTStorage g() {
            this.o();
            return new WorldNBTStorage(this, Convertable.this.j);
        }

        public WorldInfo a(Dynamic<?> dynamic) {
            this.o();
            return Convertable.this.a(dynamic, this.c, false);
        }

        public Dynamic<?> h() throws IOException {
            return this.b(false);
        }

        public Dynamic<?> i() throws IOException {
            return this.b(true);
        }

        private Dynamic<?> b(boolean flag) throws IOException {
            this.o();
            return Convertable.a(flag ? this.c.c() : this.c.b(), Convertable.this.j);
        }

        public void a(IRegistryCustom iregistrycustom, SaveData savedata) {
            this.a(iregistrycustom, savedata, null);
        }

        public void a(IRegistryCustom iregistrycustom, SaveData savedata, @Nullable NBTTagCompound nbttagcompound) {
            NBTTagCompound nbttagcompound1 = savedata.a(iregistrycustom, nbttagcompound);
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            nbttagcompound2.a(Convertable.a, nbttagcompound1);
            this.a(nbttagcompound2);
        }

        private void a(NBTTagCompound nbttagcompound) {
            Path path = this.c.f();
            try {
                Path path1 = Files.createTempFile(path, "level", ".dat", new FileAttribute[0]);
                NBTCompressedStreamTools.a(nbttagcompound, path1);
                Path path2 = this.c.c();
                Path path3 = this.c.b();
                SystemUtils.a(path3, path1, path2);
            }
            catch (Exception exception) {
                c.error("Failed to save level {}", (Object)path, (Object)exception);
            }
        }

        public Optional<Path> j() {
            return !this.b.a() ? Optional.empty() : Optional.of(this.c.d());
        }

        public void k() throws IOException {
            this.o();
            final Path path = this.c.e();
            c.info("Deleting level {}", (Object)this.d);
            for (int i2 = 1; i2 <= 5; ++i2) {
                c.info("Attempt {}...", (Object)i2);
                try {
                    Files.walkFileTree(this.c.f(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        public FileVisitResult a(Path path1, BasicFileAttributes basicfileattributes) throws IOException {
                            if (!path1.equals(path)) {
                                Convertable.c.debug("Deleting {}", (Object)path1);
                                Files.delete(path1);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        public FileVisitResult a(Path path1, @Nullable IOException ioexception) throws IOException {
                            if (ioexception != null) {
                                throw ioexception;
                            }
                            if (path1.equals(ConversionSession.this.c.f())) {
                                ConversionSession.this.b.close();
                                Files.deleteIfExists(path);
                            }
                            Files.delete(path1);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    break;
                }
                catch (IOException ioexception) {
                    if (i2 >= 5) {
                        throw ioexception;
                    }
                    c.warn("Failed to delete {}", (Object)this.c.f(), (Object)ioexception);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }

        public void a(String s2) throws IOException {
            this.a((NBTTagCompound nbttagcompound) -> nbttagcompound.a("LevelName", s2.trim()));
        }

        public void b(String s2) throws IOException {
            this.a((NBTTagCompound nbttagcompound) -> {
                nbttagcompound.a("LevelName", s2.trim());
                nbttagcompound.r("Player");
            });
        }

        private void a(Consumer<NBTTagCompound> consumer) throws IOException {
            this.o();
            NBTTagCompound nbttagcompound = Convertable.c(this.c.b());
            consumer.accept(nbttagcompound.n(Convertable.a));
            this.a(nbttagcompound);
        }

        public long l() throws IOException {
            this.o();
            String s2 = LocalDateTime.now().format(d);
            String s1 = s2 + "_" + this.d;
            Path path = Convertable.this.d();
            try {
                FileUtils.c(path);
            }
            catch (IOException ioexception) {
                throw new RuntimeException(ioexception);
            }
            Path path1 = path.resolve(FileUtils.a(path, s1, ".zip"));
            try (final ZipOutputStream zipoutputstream = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(path1, new OpenOption[0])));){
                final Path path2 = Paths.get(this.d, new String[0]);
                Files.walkFileTree(this.c.f(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    public FileVisitResult a(Path path3, BasicFileAttributes basicfileattributes) throws IOException {
                        if (path3.endsWith("session.lock")) {
                            return FileVisitResult.CONTINUE;
                        }
                        String s2 = path2.resolve(ConversionSession.this.c.f().relativize(path3)).toString().replace('\\', '/');
                        ZipEntry zipentry = new ZipEntry(s2);
                        zipoutputstream.putNextEntry(zipentry);
                        com.google.common.io.Files.asByteSource((File)path3.toFile()).copyTo((OutputStream)zipoutputstream);
                        zipoutputstream.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            return Files.size(path1);
        }

        public boolean m() {
            return Files.exists(this.c.b(), new LinkOption[0]) || Files.exists(this.c.c(), new LinkOption[0]);
        }

        @Override
        public void close() throws IOException {
            this.b.close();
        }

        public boolean n() {
            return SystemUtils.a(this.c.b(), this.c.c(), this.c.a(LocalDateTime.now()), true);
        }

        @Nullable
        public Instant a(boolean flag) {
            return Convertable.d(flag ? this.c.c() : this.c.b());
        }
    }
}

