/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.players.NameAndId;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.FileNameDateFormatter;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.TagValueOutput;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class WorldNBTStorage {
    private static final Logger b = LogUtils.getLogger();
    private final File c;
    protected final DataFixer a;
    private static final DateTimeFormatter d = FileNameDateFormatter.a();

    public WorldNBTStorage(Convertable.ConversionSession convertable_conversionsession, DataFixer datafixer) {
        this.a = datafixer;
        this.c = convertable_conversionsession.a(SavedFile.c).toFile();
        this.c.mkdirs();
    }

    public void a(EntityHuman entityhuman) {
        if (SpigotConfig.disablePlayerDataSaving) {
            return;
        }
        try (ProblemReporter.j problemreporter_j = new ProblemReporter.j(entityhuman.en(), b);){
            TagValueOutput tagvalueoutput = TagValueOutput.a(problemreporter_j, entityhuman.ej());
            entityhuman.d(tagvalueoutput);
            Path path = this.c.toPath();
            Path path1 = Files.createTempFile(path, entityhuman.cU() + "-", ".dat", new FileAttribute[0]);
            NBTTagCompound nbttagcompound = tagvalueoutput.b();
            NBTCompressedStreamTools.a(nbttagcompound, path1);
            Path path2 = path.resolve(entityhuman.cU() + ".dat");
            Path path3 = path.resolve(entityhuman.cU() + ".dat_old");
            SystemUtils.a(path2, path1, path3);
        }
        catch (Exception exception) {
            b.warn("Failed to save player data for {}", (Object)entityhuman.ap());
        }
    }

    private void a(NameAndId nameandid, String s2) {
        Path path = this.c.toPath();
        String s1 = nameandid.a().toString();
        Path path1 = path.resolve(s1 + s2);
        Path path2 = path.resolve(s1 + "_corrupted_" + LocalDateTime.now().format(d) + s2);
        if (Files.isRegularFile(path1, new LinkOption[0])) {
            try {
                Files.copy(path1, path2, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            }
            catch (Exception exception) {
                b.warn("Failed to copy the player.dat file for {}", (Object)nameandid.b(), (Object)exception);
            }
        }
    }

    private Optional<NBTTagCompound> b(NameAndId nameandid, String s2) {
        File file = this.c;
        String s1 = nameandid.a().toString();
        File file1 = new File(file, s1 + s2);
        boolean usingWrongFile = false;
        if (!file1.exists() && (file1 = new File(file, NameAndId.a(nameandid.b()).a().toString() + s2)).exists()) {
            usingWrongFile = true;
            Bukkit.getServer().getLogger().warning("Using offline mode UUID file for player " + nameandid.b() + " as it is the only copy we can find.");
        }
        if (file1.exists() && file1.isFile()) {
            try {
                Optional<NBTTagCompound> optional = Optional.of(NBTCompressedStreamTools.a(file1.toPath(), NBTReadLimiter.a()));
                if (usingWrongFile) {
                    file1.renameTo(new File(file1.getPath() + ".offline-read"));
                }
                return optional;
            }
            catch (Exception exception) {
                b.warn("Failed to load player data for {}", (Object)nameandid.b());
            }
        }
        return Optional.empty();
    }

    public Optional<NBTTagCompound> load(EntityHuman entityhuman) {
        return this.a(entityhuman.gA()).map(nbttagcompound -> {
            if (entityhuman instanceof EntityPlayer) {
                CraftPlayer player = (CraftPlayer)entityhuman.getBukkitEntity();
                long modified = new File(this.c, entityhuman.cU() + ".dat").lastModified();
                if (modified < player.getFirstPlayed()) {
                    player.setFirstPlayed(modified);
                }
            }
            return nbttagcompound;
        });
    }

    public Optional<NBTTagCompound> a(NameAndId nameandid) {
        Optional<NBTTagCompound> optional = this.b(nameandid, ".dat");
        if (optional.isEmpty()) {
            this.a(nameandid, ".dat");
        }
        return optional.or(() -> this.b(nameandid, ".dat_old")).map(nbttagcompound -> {
            int i2 = GameProfileSerializer.b(nbttagcompound, -1);
            nbttagcompound = DataFixTypes.c.a(this.a, (NBTTagCompound)nbttagcompound, i2);
            return nbttagcompound;
        });
    }

    public File getPlayerDir() {
        return this.c;
    }
}

