/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.block;

import java.util.Objects;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.block.entity.TileEntityEndGateway;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.EndGateway;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;

public class CraftEndGateway
extends CraftBlockEntityState<TileEntityEndGateway>
implements EndGateway {
    public CraftEndGateway(World world, TileEntityEndGateway tileEntity) {
        super(world, tileEntity);
    }

    protected CraftEndGateway(CraftEndGateway state, Location location) {
        super(state, location);
    }

    public Location getExitLocation() {
        BlockPosition pos = ((TileEntityEndGateway)this.getSnapshot()).k;
        return pos == null ? null : CraftLocation.toBukkit(pos, this.isPlaced() ? this.getWorld() : null);
    }

    public void setExitLocation(Location location) {
        if (location == null) {
            ((TileEntityEndGateway)this.getSnapshot()).k = null;
        } else {
            if (!Objects.equals(location.getWorld(), this.isPlaced() ? this.getWorld() : null)) {
                throw new IllegalArgumentException("Cannot set exit location to different world");
            }
            ((TileEntityEndGateway)this.getSnapshot()).k = CraftLocation.toBlockPosition(location);
        }
    }

    public boolean isExactTeleport() {
        return ((TileEntityEndGateway)this.getSnapshot()).l;
    }

    public void setExactTeleport(boolean exact) {
        ((TileEntityEndGateway)this.getSnapshot()).l = exact;
    }

    public long getAge() {
        return ((TileEntityEndGateway)this.getSnapshot()).i;
    }

    public void setAge(long age) {
        ((TileEntityEndGateway)this.getSnapshot()).i = age;
    }

    @Override
    protected void applyTo(TileEntityEndGateway endGateway) {
        super.applyTo(endGateway);
        if (((TileEntityEndGateway)this.getSnapshot()).k == null) {
            endGateway.k = null;
        }
    }

    @Override
    public CraftEndGateway copy() {
        return new CraftEndGateway(this, null);
    }

    @Override
    public CraftEndGateway copy(Location location) {
        return new CraftEndGateway(this, location);
    }
}

