/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.item.EnumColor;
import org.bukkit.DyeColor;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftTameableAnimal;
import org.bukkit.craftbukkit.v1_21_R6.registry.CraftOldEnumRegistryItem;
import org.bukkit.entity.Cat;

public class CraftCat
extends CraftTameableAnimal
implements Cat {
    public CraftCat(CraftServer server, EntityCat entity) {
        super(server, entity);
    }

    @Override
    public EntityCat getHandle() {
        return (EntityCat)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftCat";
    }

    public Cat.Type getCatType() {
        return CraftType.minecraftHolderToBukkit(this.getHandle().gU());
    }

    public void setCatType(Cat.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Cannot have null Type");
        this.getHandle().b(CraftType.bukkitToMinecraftHolder(type));
    }

    public DyeColor getCollarColor() {
        return DyeColor.getByWoolData((byte)((byte)this.getHandle().gW().a()));
    }

    public void setCollarColor(DyeColor color) {
        this.getHandle().a(EnumColor.a(color.getWoolData()));
    }

    public static class CraftType
    extends CraftOldEnumRegistryItem<Cat.Type, CatVariant>
    implements Cat.Type {
        private static int count = 0;

        public static Cat.Type minecraftToBukkit(CatVariant minecraft) {
            return (Cat.Type)CraftRegistry.minecraftToBukkit(minecraft, Registries.aO, Registry.CAT_VARIANT);
        }

        public static Cat.Type minecraftHolderToBukkit(Holder<CatVariant> minecraft) {
            return CraftType.minecraftToBukkit(minecraft.a());
        }

        public static CatVariant bukkitToMinecraft(Cat.Type bukkit) {
            return (CatVariant)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static Holder<CatVariant> bukkitToMinecraftHolder(Cat.Type bukkit) {
            return CraftRegistry.bukkitToMinecraftHolder(bukkit, Registries.aO);
        }

        public CraftType(NamespacedKey key, Holder<CatVariant> handle) {
            super(key, handle, count++);
        }

        public NamespacedKey getKey() {
            return this.getKeyOrThrow();
        }
    }
}

