/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.critereon.CriterionConditionItem;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.advancements.critereon.DataComponentMatchers;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentExactPredicate;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R6.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLegacy;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftMagicNumbers;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;
import org.jetbrains.annotations.ApiStatus;

@DelegateDeserialization(value=ItemStack.class)
public final class CraftItemStack
extends ItemStack {
    net.minecraft.world.item.ItemStack handle;
    private boolean isForInventoryDrop;

    public static net.minecraft.world.item.ItemStack asNMSCopy(ItemStack original) {
        if (original instanceof CraftItemStack) {
            CraftItemStack stack = (CraftItemStack)original;
            return stack.handle == null ? net.minecraft.world.item.ItemStack.l : stack.handle.v();
        }
        if (original == null || original.getType() == Material.AIR) {
            return net.minecraft.world.item.ItemStack.l;
        }
        Item item = CraftItemType.bukkitToMinecraft(original.getType());
        if (item == null) {
            return net.minecraft.world.item.ItemStack.l;
        }
        net.minecraft.world.item.ItemStack stack = new net.minecraft.world.item.ItemStack(item, original.getAmount());
        if (original.hasItemMeta()) {
            CraftItemStack.setItemMeta(stack, original.getItemMeta());
        }
        return stack;
    }

    public static net.minecraft.world.item.ItemStack copyNMSStack(net.minecraft.world.item.ItemStack original, int amount) {
        net.minecraft.world.item.ItemStack stack = original.v();
        stack.e(amount);
        return stack;
    }

    public static ItemStack asBukkitCopy(net.minecraft.world.item.ItemStack original) {
        if (original.f()) {
            return new ItemStack(Material.AIR);
        }
        ItemStack stack = new ItemStack(CraftItemType.minecraftToBukkit(original.h()), original.M());
        if (CraftItemStack.hasItemMeta(original)) {
            stack.setItemMeta(CraftItemStack.getItemMeta(original));
        }
        return stack;
    }

    public static CraftItemStack asCraftMirror(net.minecraft.world.item.ItemStack original) {
        return new CraftItemStack(original == null || original.f() ? null : original);
    }

    public static CraftItemStack asCraftCopy(ItemStack original) {
        if (original instanceof CraftItemStack) {
            CraftItemStack stack = (CraftItemStack)original;
            return new CraftItemStack(stack.handle == null ? null : stack.handle.v());
        }
        return new CraftItemStack(original);
    }

    public static CraftItemStack asNewCraftStack(Item item) {
        return CraftItemStack.asNewCraftStack(item, 1);
    }

    public static CraftItemStack asNewCraftStack(Item item, int amount) {
        return new CraftItemStack(CraftItemType.minecraftToBukkit(item), amount, 0, null);
    }

    public static CriterionConditionItem asCriterionConditionItem(ItemStack original) {
        net.minecraft.world.item.ItemStack nms = CraftItemStack.asNMSCopy(original);
        DataComponentExactPredicate predicate = DataComponentExactPredicate.a(PatchedDataComponentMap.a(DataComponentMap.a, nms.d()));
        return new CriterionConditionItem(Optional.of(HolderSet.a(nms.i())), CriterionConditionValue.IntegerRange.c, new DataComponentMatchers(predicate, Collections.emptyMap()));
    }

    private CraftItemStack(net.minecraft.world.item.ItemStack item) {
        this.handle = item;
    }

    private CraftItemStack(ItemStack item) {
        this(item.getType(), item.getAmount(), item.getDurability(), item.hasItemMeta() ? item.getItemMeta() : null);
    }

    private CraftItemStack(Material type, int amount, short durability, ItemMeta itemMeta) {
        this.setType(type);
        this.setAmount(amount);
        this.setDurability(durability);
        this.setItemMeta(itemMeta);
    }

    @ApiStatus.Internal
    public boolean isForInventoryDrop() {
        return this.isForInventoryDrop;
    }

    @ApiStatus.Internal
    public ItemStack markForInventoryDrop() {
        this.isForInventoryDrop = true;
        return this;
    }

    public MaterialData getData() {
        return this.handle != null ? CraftMagicNumbers.getMaterialData(this.handle.h()) : super.getData();
    }

    public Material getType() {
        return this.handle != null ? CraftItemType.minecraftToBukkit(this.handle.h()) : Material.AIR;
    }

    public void setType(Material type) {
        if (this.getType() == type) {
            return;
        }
        if (type == Material.AIR) {
            this.handle = null;
        } else if (CraftItemType.bukkitToMinecraft(type) == null) {
            this.handle = null;
        } else if (this.handle == null) {
            this.handle = new net.minecraft.world.item.ItemStack(CraftItemType.bukkitToMinecraft(type), 1);
        } else {
            this.handle.setItem(CraftItemType.bukkitToMinecraft(type));
            if (this.hasItemMeta()) {
                CraftItemStack.setItemMeta(this.handle, CraftItemStack.getItemMeta(this.handle));
            }
        }
        this.setData(null);
    }

    public int getAmount() {
        return this.handle != null ? this.handle.M() : 0;
    }

    public void setAmount(int amount) {
        if (this.handle == null) {
            return;
        }
        this.handle.e(amount);
        if (amount == 0) {
            this.handle = null;
        }
    }

    public void setDurability(short durability) {
        if (this.handle != null) {
            this.handle.b(durability);
        }
    }

    public short getDurability() {
        if (this.handle != null) {
            return (short)this.handle.o();
        }
        return -1;
    }

    public int getMaxStackSize() {
        return this.handle == null ? Material.AIR.getMaxStackSize() : this.handle.k();
    }

    public void addUnsafeEnchantment(Enchantment ench, int level) {
        Preconditions.checkArgument((ench != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        if (!CraftItemStack.makeTag(this.handle)) {
            return;
        }
        ItemEnchantments list = CraftItemStack.getEnchantmentList(this.handle);
        if (list == null) {
            list = ItemEnchantments.a;
        }
        ItemEnchantments.a listCopy = new ItemEnchantments.a(list);
        listCopy.a(CraftEnchantment.bukkitToMinecraftHolder(ench), level);
        this.handle.b(DataComponents.l, listCopy.b());
    }

    static boolean makeTag(net.minecraft.world.item.ItemStack item) {
        return item != null;
    }

    public boolean containsEnchantment(Enchantment ench) {
        return this.getEnchantmentLevel(ench) > 0;
    }

    public int getEnchantmentLevel(Enchantment ench) {
        Preconditions.checkArgument((ench != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        if (this.handle == null) {
            return 0;
        }
        return EnchantmentManager.a(CraftEnchantment.bukkitToMinecraftHolder(ench), this.handle);
    }

    public int removeEnchantment(Enchantment ench) {
        Preconditions.checkArgument((ench != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        ItemEnchantments list = CraftItemStack.getEnchantmentList(this.handle);
        if (list == null) {
            return 0;
        }
        int level = this.getEnchantmentLevel(ench);
        if (level <= 0) {
            return 0;
        }
        int size = list.c();
        if (size == 1) {
            this.handle.e(DataComponents.l);
            return level;
        }
        ItemEnchantments.a listCopy = new ItemEnchantments.a(list);
        listCopy.a(CraftEnchantment.bukkitToMinecraftHolder(ench), -1);
        this.handle.b(DataComponents.l, listCopy.b());
        return level;
    }

    public void removeEnchantments() {
        this.handle.e(DataComponents.l);
    }

    public Map<Enchantment, Integer> getEnchantments() {
        return CraftItemStack.getEnchantments(this.handle);
    }

    static Map<Enchantment, Integer> getEnchantments(net.minecraft.world.item.ItemStack item) {
        ItemEnchantments list;
        ItemEnchantments itemEnchantments = list = item != null && item.F() ? item.a(DataComponents.l) : null;
        if (list == null || list.c() == 0) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder result = ImmutableMap.builder();
        list.b().forEach(entry -> {
            Holder id = (Holder)entry.getKey();
            int level = entry.getIntValue();
            Enchantment enchant = CraftEnchantment.minecraftHolderToBukkit(id);
            if (enchant != null) {
                result.put((Object)enchant, (Object)level);
            }
        });
        return result.build();
    }

    static ItemEnchantments getEnchantmentList(net.minecraft.world.item.ItemStack item) {
        return item != null && item.F() ? item.a(DataComponents.l) : null;
    }

    public CraftItemStack clone() {
        CraftItemStack itemStack = (CraftItemStack)super.clone();
        if (this.handle != null) {
            itemStack.handle = this.handle.v();
        }
        return itemStack;
    }

    public ItemMeta getItemMeta() {
        return CraftItemStack.getItemMeta(this.handle);
    }

    public static ItemMeta getItemMeta(net.minecraft.world.item.ItemStack item) {
        if (!CraftItemStack.hasItemMeta(item)) {
            return CraftItemFactory.instance().getItemMeta(CraftItemStack.getType(item));
        }
        return ((CraftItemType)CraftItemType.minecraftToBukkitNew(item.h())).getItemMeta(item);
    }

    static Material getType(net.minecraft.world.item.ItemStack item) {
        return item == null ? Material.AIR : CraftItemType.minecraftToBukkit(item.h());
    }

    public boolean setItemMeta(ItemMeta itemMeta) {
        return CraftItemStack.setItemMeta(this.handle, itemMeta);
    }

    public static boolean setItemMeta(net.minecraft.world.item.ItemStack item, ItemMeta itemMeta) {
        if (item == null) {
            return false;
        }
        if (CraftItemFactory.instance().equals(itemMeta, null)) {
            item.restorePatch(DataComponentPatch.a);
            return true;
        }
        if (!CraftItemFactory.instance().isApplicable(itemMeta, CraftItemStack.getType(item))) {
            return false;
        }
        itemMeta = CraftItemFactory.instance().asMetaFor(itemMeta, CraftItemStack.getType(item));
        if (itemMeta == null) {
            return true;
        }
        if (!((CraftMetaItem)itemMeta).isEmpty()) {
            CraftMetaItem.Applicator tag = new CraftMetaItem.Applicator();
            ((CraftMetaItem)itemMeta).applyToItem(tag);
            item.restorePatch(tag.build());
        }
        if (item.h() != null && item.p() > 0) {
            item.b(item.o());
        }
        return true;
    }

    public boolean isSimilar(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack == this) {
            return true;
        }
        if (!(stack instanceof CraftItemStack)) {
            return stack.getClass() == ItemStack.class && stack.isSimilar((ItemStack)this);
        }
        CraftItemStack that = (CraftItemStack)stack;
        if (this.handle == that.handle) {
            return true;
        }
        if (this.handle == null || that.handle == null) {
            return false;
        }
        Material comparisonType = CraftLegacy.fromLegacy(that.getType());
        if (comparisonType != this.getType() || this.getDurability() != that.getDurability()) {
            return false;
        }
        return this.hasItemMeta() ? that.hasItemMeta() && this.handle.a().equals(that.handle.a()) : !that.hasItemMeta();
    }

    public boolean hasItemMeta() {
        return CraftItemStack.hasItemMeta(this.handle) && !CraftItemFactory.instance().equals(this.getItemMeta(), null);
    }

    static boolean hasItemMeta(net.minecraft.world.item.ItemStack item) {
        return item != null && !item.d().d();
    }
}

