/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.component.MapItemColor;
import net.minecraft.world.item.component.MapPostProcessing;
import net.minecraft.world.level.saveddata.maps.MapId;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R6.inventory.ItemMetaKey;
import org.bukkit.craftbukkit.v1_21_R6.inventory.SerializableMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.map.MapView;

@DelegateDeserialization(value=SerializableMeta.class)
class CraftMetaMap
extends CraftMetaItem
implements MapMeta {
    static final CraftMetaItem.ItemMetaKeyType<MapPostProcessing> MAP_POST_PROCESSING = new CraftMetaItem.ItemMetaKeyType<MapPostProcessing>(DataComponents.O);
    static final ItemMetaKey MAP_SCALING = new ItemMetaKey("scaling");
    @Deprecated
    static final ItemMetaKey MAP_LOC_NAME = new ItemMetaKey("display-loc-name");
    static final CraftMetaItem.ItemMetaKeyType<MapItemColor> MAP_COLOR = new CraftMetaItem.ItemMetaKeyType<MapItemColor>(DataComponents.L, "display-map-color");
    static final CraftMetaItem.ItemMetaKeyType<MapId> MAP_ID = new CraftMetaItem.ItemMetaKeyType<MapId>(DataComponents.M, "map-id");
    static final byte SCALING_EMPTY = 0;
    static final byte SCALING_TRUE = 1;
    static final byte SCALING_FALSE = 2;
    private Integer mapId;
    private byte scaling = 0;
    private Color color;

    CraftMetaMap(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaMap)) {
            return;
        }
        CraftMetaMap map = (CraftMetaMap)meta;
        this.mapId = map.mapId;
        this.scaling = map.scaling;
        this.color = map.color;
    }

    CraftMetaMap(DataComponentPatch tag) {
        super(tag);
        CraftMetaMap.getOrEmpty(tag, MAP_ID).ifPresent(mapId -> {
            this.mapId = mapId.b();
        });
        CraftMetaMap.getOrEmpty(tag, MAP_POST_PROCESSING).ifPresent(mapPostProcessing -> {
            this.scaling = (byte)(mapPostProcessing == MapPostProcessing.b ? 1 : 2);
        });
        CraftMetaMap.getOrEmpty(tag, MAP_COLOR).ifPresent(mapColor -> {
            try {
                this.color = Color.fromRGB((int)mapColor.a());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        });
    }

    CraftMetaMap(Map<String, Object> map) {
        super(map);
        Color color;
        String locName;
        Boolean scaling;
        Integer id = SerializableMeta.getObject(Integer.class, map, CraftMetaMap.MAP_ID.BUKKIT, true);
        if (id != null) {
            this.setMapId(id);
        }
        if ((scaling = SerializableMeta.getObject(Boolean.class, map, CraftMetaMap.MAP_SCALING.BUKKIT, true)) != null) {
            this.setScaling(scaling);
        }
        if ((locName = SerializableMeta.getString(map, CraftMetaMap.MAP_LOC_NAME.BUKKIT, true)) != null) {
            this.setLocationName(locName);
        }
        if ((color = SerializableMeta.getObject(Color.class, map, CraftMetaMap.MAP_COLOR.BUKKIT, true)) != null) {
            this.setColor(color);
        }
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator tag) {
        super.applyToItem(tag);
        if (this.hasMapId()) {
            tag.put(MAP_ID, new MapId(this.getMapId()));
        }
        if (this.hasScaling()) {
            tag.put(MAP_POST_PROCESSING, this.isScaling() ? MapPostProcessing.b : MapPostProcessing.a);
        }
        if (this.hasColor()) {
            tag.put(MAP_COLOR, new MapItemColor(this.color.asRGB()));
        }
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isMapEmpty();
    }

    boolean isMapEmpty() {
        return !this.hasMapId() && !(this.hasScaling() | this.hasLocationName()) && !this.hasColor();
    }

    public boolean hasMapId() {
        return this.mapId != null;
    }

    public int getMapId() {
        return this.mapId;
    }

    public void setMapId(int id) {
        this.mapId = id;
    }

    public boolean hasMapView() {
        return this.mapId != null;
    }

    public MapView getMapView() {
        Preconditions.checkState((boolean)this.hasMapView(), (Object)"Item does not have map associated - check hasMapView() first!");
        return Bukkit.getMap((int)this.mapId);
    }

    public void setMapView(MapView map) {
        this.mapId = map != null ? Integer.valueOf(map.getId()) : null;
    }

    boolean hasScaling() {
        return this.scaling != 0;
    }

    public boolean isScaling() {
        return this.scaling == 1;
    }

    public void setScaling(boolean scaling) {
        this.scaling = (byte)(scaling ? 1 : 2);
    }

    public boolean hasLocationName() {
        return this.hasLocalizedName();
    }

    public String getLocationName() {
        return this.getLocalizedName();
    }

    public void setLocationName(String name) {
        this.setLocalizedName(name);
    }

    public boolean hasColor() {
        return this.color != null;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaMap) {
            CraftMetaMap that = (CraftMetaMap)meta;
            return this.scaling == that.scaling && (this.hasMapId() ? that.hasMapId() && this.mapId.equals(that.mapId) : !that.hasMapId()) && (this.hasColor() ? that.hasColor() && this.color.equals((Object)that.color) : !that.hasColor());
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaMap || this.isMapEmpty());
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasMapId()) {
            hash = 61 * hash + this.mapId.hashCode();
        }
        if (this.hasScaling()) {
            hash ^= 0x22222222 << (this.isScaling() ? 1 : -1);
        }
        if (this.hasColor()) {
            hash = 61 * hash + this.color.hashCode();
        }
        return original != hash ? CraftMetaMap.class.hashCode() ^ hash : hash;
    }

    @Override
    public CraftMetaMap clone() {
        return (CraftMetaMap)super.clone();
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.hasMapId()) {
            builder.put((Object)CraftMetaMap.MAP_ID.BUKKIT, (Object)this.getMapId());
        }
        if (this.hasScaling()) {
            builder.put((Object)CraftMetaMap.MAP_SCALING.BUKKIT, (Object)this.isScaling());
        }
        if (this.hasColor()) {
            builder.put((Object)CraftMetaMap.MAP_COLOR.BUKKIT, (Object)this.getColor());
        }
        return builder;
    }
}

