/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.decoration.EntityPainting;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityGhast;
import org.spigotmc.ActivationRange;
import org.spigotmc.SpigotWorldConfig;

public class TrackingRange {
    public static int getEntityTrackingRange(Entity entity, int defaultRange) {
        if (defaultRange == 0) {
            return defaultRange;
        }
        SpigotWorldConfig config = entity.an().spigotConfig;
        if (entity instanceof EntityPlayer) {
            return config.playerTrackingRange;
        }
        if (entity.activationType == ActivationRange.ActivationType.MONSTER || entity.activationType == ActivationRange.ActivationType.RAIDER) {
            return config.monsterTrackingRange;
        }
        if (entity instanceof EntityGhast) {
            if (config.monsterTrackingRange > config.monsterActivationRange) {
                return config.monsterTrackingRange;
            }
            return config.monsterActivationRange;
        }
        if (entity.activationType == ActivationRange.ActivationType.ANIMAL) {
            return config.animalTrackingRange;
        }
        if (entity instanceof EntityItemFrame || entity instanceof EntityPainting || entity instanceof EntityItem || entity instanceof EntityExperienceOrb) {
            return config.miscTrackingRange;
        }
        if (entity instanceof Display) {
            return config.displayTrackingRange;
        }
        return config.otherTrackingRange;
    }
}

